/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.model;

import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationIdentifierFormatException;
import org.apache.commons.lang3.StringUtils;

public class IssueServiceConfigurationIdentifier {
    private final String serviceId;
    private final String name;

    public String format() {
        return String.format("%s//%s", this.serviceId, this.name);
    }

    public static IssueServiceConfigurationIdentifier parse(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        String serviceId = StringUtils.substringBefore((String)value, (String)"//").trim();
        String name = StringUtils.substringAfter((String)value, (String)"//").trim();
        if (StringUtils.isNotBlank((CharSequence)serviceId) && StringUtils.isNotBlank((CharSequence)name)) {
            return new IssueServiceConfigurationIdentifier(serviceId, name);
        }
        throw new IssueServiceConfigurationIdentifierFormatException(value);
    }

    @ConstructorProperties(value={"serviceId", "name"})
    public IssueServiceConfigurationIdentifier(String serviceId, String name) {
        this.serviceId = serviceId;
        this.name = name;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueServiceConfigurationIdentifier)) {
            return false;
        }
        IssueServiceConfigurationIdentifier other = (IssueServiceConfigurationIdentifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        if (this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        return !(this$name == null ? other$name != null : !this$name.equals(other$name));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueServiceConfigurationIdentifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        return result;
    }

    public String toString() {
        return "IssueServiceConfigurationIdentifier(serviceId=" + this.getServiceId() + ", name=" + this.getName() + ")";
    }
}

