/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.model;

import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.support.MessageAnnotationUtils;
import net.nemerosa.ontrack.model.support.MessageAnnotator;
import org.jetbrains.annotations.NotNull;

public class ConfiguredIssueService {
    private final IssueServiceExtension issueServiceExtension;
    private final IssueServiceConfiguration issueServiceConfiguration;

    public String formatIssuesInMessage(String message) {
        return this.issueServiceExtension.getMessageAnnotator(this.issueServiceConfiguration).map(annotator -> MessageAnnotationUtils.annotate((String)message, Collections.singletonList(annotator))).orElse("");
    }

    public String getLinkForAllIssues(List<Issue> issues) {
        return this.issueServiceExtension.getLinkForAllIssues(this.issueServiceConfiguration, issues);
    }

    public Issue getIssue(String issueKey) {
        return this.issueServiceExtension.getIssue(this.issueServiceConfiguration, issueKey);
    }

    public IssueServiceConfigurationRepresentation getIssueServiceConfigurationRepresentation() {
        return IssueServiceConfigurationRepresentation.Companion.of(this.issueServiceExtension, this.issueServiceConfiguration);
    }

    public Optional<MessageAnnotator> getMessageAnnotator() {
        return this.issueServiceExtension.getMessageAnnotator(this.issueServiceConfiguration);
    }

    public Set<String> extractIssueKeysFromMessage(String message) {
        return this.issueServiceExtension.extractIssueKeysFromMessage(this.issueServiceConfiguration, message);
    }

    public Optional<String> getIssueId(String token) {
        return this.issueServiceExtension.getIssueId(this.issueServiceConfiguration, token);
    }

    public Collection<? extends Issue> getLinkedIssues(Project project, Issue issue) {
        return this.issueServiceExtension.getLinkedIssues(project, this.issueServiceConfiguration, issue);
    }

    @NotNull
    public String getMessageRegex(@NotNull Issue issue) {
        return this.issueServiceExtension.getMessageRegex(this.issueServiceConfiguration, issue);
    }

    @ConstructorProperties(value={"issueServiceExtension", "issueServiceConfiguration"})
    public ConfiguredIssueService(IssueServiceExtension issueServiceExtension, IssueServiceConfiguration issueServiceConfiguration) {
        this.issueServiceExtension = issueServiceExtension;
        this.issueServiceConfiguration = issueServiceConfiguration;
    }

    public IssueServiceExtension getIssueServiceExtension() {
        return this.issueServiceExtension;
    }

    public IssueServiceConfiguration getIssueServiceConfiguration() {
        return this.issueServiceConfiguration;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConfiguredIssueService)) {
            return false;
        }
        ConfiguredIssueService other = (ConfiguredIssueService)o;
        if (!other.canEqual(this)) {
            return false;
        }
        IssueServiceExtension this$issueServiceExtension = this.getIssueServiceExtension();
        IssueServiceExtension other$issueServiceExtension = other.getIssueServiceExtension();
        if (this$issueServiceExtension == null ? other$issueServiceExtension != null : !this$issueServiceExtension.equals(other$issueServiceExtension)) {
            return false;
        }
        IssueServiceConfiguration this$issueServiceConfiguration = this.getIssueServiceConfiguration();
        IssueServiceConfiguration other$issueServiceConfiguration = other.getIssueServiceConfiguration();
        return !(this$issueServiceConfiguration == null ? other$issueServiceConfiguration != null : !this$issueServiceConfiguration.equals(other$issueServiceConfiguration));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConfiguredIssueService;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        IssueServiceExtension $issueServiceExtension = this.getIssueServiceExtension();
        result = result * 59 + ($issueServiceExtension == null ? 43 : $issueServiceExtension.hashCode());
        IssueServiceConfiguration $issueServiceConfiguration = this.getIssueServiceConfiguration();
        result = result * 59 + ($issueServiceConfiguration == null ? 43 : $issueServiceConfiguration.hashCode());
        return result;
    }

    public String toString() {
        return "ConfiguredIssueService(issueServiceExtension=" + this.getIssueServiceExtension() + ", issueServiceConfiguration=" + this.getIssueServiceConfiguration() + ")";
    }
}

