/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.export;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.nemerosa.ontrack.extension.issues.export.IssueExportService;
import net.nemerosa.ontrack.extension.issues.export.IssueExportServiceFactory;
import net.nemerosa.ontrack.extension.issues.export.IssueExportServiceNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
class IssueExportServiceFactoryImpl
implements IssueExportServiceFactory {
    private final Map<String, IssueExportService> issueExportServiceMap;

    @Autowired
    IssueExportServiceFactoryImpl(Collection<IssueExportService> issueExportServices) {
        this.issueExportServiceMap = Maps.uniqueIndex(issueExportServices, service -> service.getExportFormat().getId());
    }

    @Override
    public IssueExportService getIssueExportService(String format) throws IssueExportServiceNotFoundException {
        IssueExportService issueExportService = this.issueExportServiceMap.get(format);
        if (issueExportService != null) {
            return issueExportService;
        }
        throw new IssueExportServiceNotFoundException(format);
    }

    @Override
    public Collection<IssueExportService> getIssueExportServices() {
        return this.issueExportServiceMap.values();
    }
}

