/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.support;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueExportMoreThanOneGroupException;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;

public final class IssueServiceUtils {
    private IssueServiceUtils() {
    }

    public static Set<String> getIssueGroups(Collection<String> issueTypes, Map<String, Set<String>> groupingSpecification) {
        HashSet<String> groups = new HashSet<String>();
        for (String issueType : issueTypes) {
            for (Map.Entry<String, Set<String>> entry : groupingSpecification.entrySet()) {
                String groupName = entry.getKey();
                Set<String> groupTypes = entry.getValue();
                if (!groupTypes.contains(issueType)) continue;
                groups.add(groupName);
            }
        }
        return groups;
    }

    public static Map<String, List<Issue>> groupIssues(IssueServiceConfiguration issueServiceConfiguration, List<? extends Issue> issues, IssueChangeLogExportRequest request, BiFunction<IssueServiceConfiguration, Issue, Set<String>> issueTypesFn) {
        Set excludedTypes = request.getExcludedTypes();
        Map groupingSpecification = request.getGroupingSpecification();
        LinkedHashMap<String, List<Issue>> groupedIssues = new LinkedHashMap<String, List<Issue>>();
        for (String string : groupingSpecification.keySet()) {
            groupedIssues.put(string, new ArrayList());
        }
        for (Issue issue : issues) {
            Set<String> issueTypes = issueTypesFn.apply(issueServiceConfiguration, issue);
            if (!Collections.disjoint(excludedTypes, issueTypes)) continue;
            Set<String> issueGroups = IssueServiceUtils.getIssueGroups(issueTypes, groupingSpecification);
            if (issueGroups.size() > 1) {
                throw new IssueExportMoreThanOneGroupException(issue.getKey(), issueGroups);
            }
            String targetGroup = issueGroups.isEmpty() ? (groupingSpecification.isEmpty() ? "" : request.getAltGroup()) : (String)Iterables.get(issueGroups, (int)0);
            ArrayList<Issue> issueList = (ArrayList<Issue>)groupedIssues.get(targetGroup);
            if (issueList == null) {
                issueList = new ArrayList<Issue>();
                groupedIssues.put(targetGroup, issueList);
            }
            issueList.add(issue);
        }
        Iterator iterator = groupedIssues.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            if (!((List)entry.getValue()).isEmpty()) continue;
            iterator.remove();
        }
        return groupedIssues;
    }
}

