/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.model;

import java.beans.ConstructorProperties;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;

public class IssueServiceConfigurationRepresentation {
    private static final String SELF_ID = "self";
    private final String id;
    private final String name;
    private final String serviceId;

    public static IssueServiceConfigurationRepresentation of(IssueServiceExtension issueServiceExtension, IssueServiceConfiguration issueServiceConfiguration) {
        return new IssueServiceConfigurationRepresentation(issueServiceConfiguration.toIdentifier().format(), String.format("%s (%s)", issueServiceConfiguration.getName(), issueServiceExtension.getName()), issueServiceExtension.getId());
    }

    public static boolean isSelf(String id) {
        return SELF_ID.equals(id);
    }

    public static IssueServiceConfigurationRepresentation self(String name, String serviceId) {
        return new IssueServiceConfigurationRepresentation(SELF_ID, name, serviceId);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IssueServiceConfigurationRepresentation)) {
            return false;
        }
        IssueServiceConfigurationRepresentation other = (IssueServiceConfigurationRepresentation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.getId();
        String other$id = other.getId();
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$serviceId = this.getServiceId();
        String other$serviceId = other.getServiceId();
        return !(this$serviceId == null ? other$serviceId != null : !this$serviceId.equals(other$serviceId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof IssueServiceConfigurationRepresentation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.getId();
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $serviceId = this.getServiceId();
        result = result * 59 + ($serviceId == null ? 43 : $serviceId.hashCode());
        return result;
    }

    public String toString() {
        return "IssueServiceConfigurationRepresentation(id=" + this.getId() + ", name=" + this.getName() + ", serviceId=" + this.getServiceId() + ")";
    }

    @ConstructorProperties(value={"id", "name", "serviceId"})
    protected IssueServiceConfigurationRepresentation(String id, String name, String serviceId) {
        this.id = id;
        this.name = name;
        this.serviceId = serviceId;
    }
}

