/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import net.nemerosa.ontrack.extension.issues.export.ExportFormat;
import net.nemerosa.ontrack.extension.issues.export.ExportedIssues;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.model.extension.Extension;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.support.MessageAnnotator;

public interface IssueServiceExtension
extends Extension {
    public String getId();

    public String getName();

    public List<? extends IssueServiceConfiguration> getConfigurationList();

    public IssueServiceConfiguration getConfigurationByName(String var1);

    public boolean validIssueToken(String var1);

    public Set<String> extractIssueKeysFromMessage(IssueServiceConfiguration var1, String var2);

    public Optional<MessageAnnotator> getMessageAnnotator(IssueServiceConfiguration var1);

    public String getLinkForAllIssues(IssueServiceConfiguration var1, List<Issue> var2);

    public Issue getIssue(IssueServiceConfiguration var1, String var2);

    public boolean containsIssueKey(IssueServiceConfiguration var1, String var2, Set<String> var3);

    public List<ExportFormat> exportFormats(IssueServiceConfiguration var1);

    public ExportedIssues exportIssues(IssueServiceConfiguration var1, List<? extends Issue> var2, IssueChangeLogExportRequest var3);

    public Optional<String> getIssueId(IssueServiceConfiguration var1, String var2);

    default public Collection<? extends Issue> getLinkedIssues(Project project, IssueServiceConfiguration issueServiceConfiguration, Issue issue) {
        return Collections.singleton(issue);
    }
}

