/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.model;

import java.time.LocalDateTime;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueStatusWrapper;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u001b\u0012\n\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0002\u001a\u00060\u0003j\u0002`\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\nR\u0017\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00060\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\nR\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\nR\u0014\u0010\u001a\u001a\u00020\u001bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\n\u00a8\u0006 "}, d2={"Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabIssueWrapper;", "Lnet/nemerosa/ontrack/extension/issues/model/Issue;", "gitlabIssue", "Lorg/gitlab4j/api/models/Issue;", "Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabIssue;", "milestoneUrl", "", "(Lorg/gitlab4j/api/models/Issue;Ljava/lang/String;)V", "displayKey", "getDisplayKey", "()Ljava/lang/String;", "getGitlabIssue", "()Lorg/gitlab4j/api/models/Issue;", "key", "getKey", "labels", "", "getLabels", "()Ljava/util/List;", "getMilestoneUrl", "status", "Lnet/nemerosa/ontrack/extension/issues/model/IssueStatus;", "getStatus", "()Lnet/nemerosa/ontrack/extension/issues/model/IssueStatus;", "summary", "getSummary", "updateTime", "Ljava/time/LocalDateTime;", "getUpdateTime", "()Ljava/time/LocalDateTime;", "url", "getUrl", "ontrack-extension-gitlab"})
public final class GitLabIssueWrapper
implements Issue {
    @NotNull
    private final org.gitlab4j.api.models.Issue gitlabIssue;
    @Nullable
    private final String milestoneUrl;
    @NotNull
    private final String url;
    @NotNull
    private final String key;
    @NotNull
    private final String displayKey;
    @NotNull
    private final String summary;
    @NotNull
    private final IssueStatus status;
    @NotNull
    private final LocalDateTime updateTime;
    @NotNull
    private final List<String> labels;

    public GitLabIssueWrapper(@NotNull org.gitlab4j.api.models.Issue gitlabIssue, @Nullable String milestoneUrl) {
        Intrinsics.checkNotNullParameter((Object)gitlabIssue, (String)"gitlabIssue");
        this.gitlabIssue = gitlabIssue;
        this.milestoneUrl = milestoneUrl;
        Object object = this.gitlabIssue.getWebUrl();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gitlabIssue.webUrl");
        this.url = object;
        this.key = String.valueOf(this.gitlabIssue.getId());
        this.displayKey = "#" + this.gitlabIssue.getId();
        object = this.gitlabIssue.getTitle();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gitlabIssue.title");
        this.summary = object;
        this.status = new GitLabIssueStatusWrapper(this.gitlabIssue.getState().name());
        this.updateTime = Time.INSTANCE.from(this.gitlabIssue.getUpdatedAt().getTime());
        object = this.gitlabIssue.getLabels();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gitlabIssue.labels");
        this.labels = object;
    }

    @NotNull
    public final org.gitlab4j.api.models.Issue getGitlabIssue() {
        return this.gitlabIssue;
    }

    @Nullable
    public final String getMilestoneUrl() {
        return this.milestoneUrl;
    }

    @NotNull
    public String getUrl() {
        return this.url;
    }

    @NotNull
    public String getKey() {
        return this.key;
    }

    @NotNull
    public String getDisplayKey() {
        return this.displayKey;
    }

    @NotNull
    public String getSummary() {
        return this.summary;
    }

    @NotNull
    public IssueStatus getStatus() {
        return this.status;
    }

    @NotNull
    public LocalDateTime getUpdateTime() {
        return this.updateTime;
    }

    @NotNull
    public final List<String> getLabels() {
        return this.labels;
    }
}

