/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.git.model.GitPullRequest;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientException;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueWrapper;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Milestone;
import org.gitlab4j.api.models.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/extension/gitlab/client/DefaultOntrackGitLabClient;", "Lnet/nemerosa/ontrack/extension/gitlab/client/OntrackGitLabClient;", "configuration", "Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabConfiguration;", "(Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabConfiguration;)V", "api", "Lorg/gitlab4j/api/GitLabApi;", "getApi", "()Lorg/gitlab4j/api/GitLabApi;", "api$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "getIssue", "Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabIssueWrapper;", "repository", "", "id", "", "getPullRequest", "Lnet/nemerosa/ontrack/extension/git/model/GitPullRequest;", "getRepositories", "", "ontrack-extension-gitlab"})
public final class DefaultOntrackGitLabClient
implements OntrackGitLabClient {
    @NotNull
    private final GitLabConfiguration configuration;
    @NotNull
    private final Logger logger;
    @NotNull
    private final Lazy api$delegate;

    public DefaultOntrackGitLabClient(@NotNull GitLabConfiguration configuration) {
        Intrinsics.checkNotNullParameter((Object)((Object)configuration), (String)"configuration");
        this.configuration = configuration;
        Logger logger = LoggerFactory.getLogger(OntrackGitLabClient.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(OntrackGitLabClient::class.java)");
        this.logger = logger;
        this.api$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GitLabApi>(this){
            final /* synthetic */ DefaultOntrackGitLabClient this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            @NotNull
            public final GitLabApi invoke() {
                String personalAccessToken = DefaultOntrackGitLabClient.access$getConfiguration$p(this.this$0).getPassword();
                GitLabApi api2 = new GitLabApi(DefaultOntrackGitLabClient.access$getConfiguration$p(this.this$0).getUrl(), personalAccessToken);
                api2.setRequestTimeout(Integer.valueOf(1000), Integer.valueOf(5000));
                api2.setIgnoreCertificateErrors(DefaultOntrackGitLabClient.access$getConfiguration$p(this.this$0).isIgnoreSslCertificate());
                return api2;
            }
        }));
    }

    private final GitLabApi getApi() {
        Lazy lazy = this.api$delegate;
        Object var2_2 = null;
        boolean bl = false;
        return (GitLabApi)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getRepositories() {
        List list;
        this.logger.debug("[gitlab] Getting repository list");
        try {
            void $this$mapTo$iv$iv;
            list = this.getApi().getProjectApi().getOwnedProjects();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"api.projectApi.ownedProjects");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Project project = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getNamespace() + "/" + it.getName();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            throw new OntrackGitLabClientException(e);
        }
        return list;
    }

    @Override
    @NotNull
    public GitLabIssueWrapper getIssue(@NotNull String repository, int id) {
        GitLabIssueWrapper gitLabIssueWrapper;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        try {
            Issue issue = this.getApi().getIssuesApi().getIssue((Object)repository, Integer.valueOf(id));
            String milestoneUrl = null;
            if (issue.getMilestone() != null) {
                Milestone milestone;
                milestoneUrl = this.configuration.getUrl() + "/projects/" + repository + "/milestones/" + ((milestone = issue.getMilestone()) == null ? null : milestone.getId());
            }
            Intrinsics.checkNotNullExpressionValue((Object)issue, (String)"issue");
            gitLabIssueWrapper = new GitLabIssueWrapper(issue, milestoneUrl);
        }
        catch (Exception e) {
            throw new OntrackGitLabClientException(e);
        }
        return gitLabIssueWrapper;
    }

    @Override
    @Nullable
    public GitPullRequest getPullRequest(@NotNull String repository, int id) {
        GitPullRequest gitPullRequest;
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        try {
            try {
                MergeRequest pr = this.getApi().getMergeRequestApi().getMergeRequest((Object)repository, Integer.valueOf(id));
                String string = "#" + id;
                String string2 = pr.getSourceBranch();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pr.sourceBranch");
                String string3 = string2;
                string2 = pr.getTargetBranch();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pr.targetBranch");
                String string4 = string2;
                string2 = pr.getTitle();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pr.title");
                String string5 = string2;
                string2 = pr.getState();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pr.state");
                String string6 = string2;
                string2 = pr.getWebUrl();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"pr.webUrl");
                gitPullRequest = new GitPullRequest(id, string, string3, string4, string5, string6, string2);
            }
            catch (FileNotFoundException ignored) {
                gitPullRequest = null;
            }
        }
        catch (IOException e) {
            throw new OntrackGitLabClientException(e);
        }
        return gitPullRequest;
    }

    public static final /* synthetic */ GitLabConfiguration access$getConfiguration$p(DefaultOntrackGitLabClient $this) {
        return $this.configuration;
    }
}

