/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.property;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.nemerosa.ontrack.extension.git.model.GitConfiguration;
import net.nemerosa.ontrack.extension.git.model.GitConfigurator;
import net.nemerosa.ontrack.extension.git.model.GitPullRequest;
import net.nemerosa.ontrack.extension.gitlab.GitLabIssueServiceExtension;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientFactory;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabGitConfiguration;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0017\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0012\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u0010\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0012J\u001a\u0010\u0014\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0016\u001a\u00020\f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lnet/nemerosa/ontrack/extension/gitlab/property/GitLabConfigurator;", "Lnet/nemerosa/ontrack/extension/git/model/GitConfigurator;", "propertyService", "Lnet/nemerosa/ontrack/model/structure/PropertyService;", "issueServiceRegistry", "Lnet/nemerosa/ontrack/extension/issues/IssueServiceRegistry;", "issueServiceExtension", "Lnet/nemerosa/ontrack/extension/gitlab/GitLabIssueServiceExtension;", "ontrackGitLabClientFactory", "Lnet/nemerosa/ontrack/extension/gitlab/client/OntrackGitLabClientFactory;", "(Lnet/nemerosa/ontrack/model/structure/PropertyService;Lnet/nemerosa/ontrack/extension/issues/IssueServiceRegistry;Lnet/nemerosa/ontrack/extension/gitlab/GitLabIssueServiceExtension;Lnet/nemerosa/ontrack/extension/gitlab/client/OntrackGitLabClientFactory;)V", "getConfiguration", "Lnet/nemerosa/ontrack/extension/git/model/GitConfiguration;", "project", "Lnet/nemerosa/ontrack/model/structure/Project;", "getConfiguredIssueService", "Lnet/nemerosa/ontrack/extension/issues/model/ConfiguredIssueService;", "property", "Lnet/nemerosa/ontrack/extension/gitlab/property/GitLabProjectConfigurationProperty;", "getGitConfiguration", "getPullRequest", "Lnet/nemerosa/ontrack/extension/git/model/GitPullRequest;", "configuration", "id", "", "isProjectConfigured", "", "ontrack-extension-gitlab"})
public class GitLabConfigurator
implements GitConfigurator {
    private final PropertyService propertyService;
    private final IssueServiceRegistry issueServiceRegistry;
    private final GitLabIssueServiceExtension issueServiceExtension;
    private final OntrackGitLabClientFactory ontrackGitLabClientFactory;

    public boolean isProjectConfigured(@NotNull Project project) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        return this.propertyService.hasProperty((ProjectEntity)project, GitLabProjectConfigurationPropertyType.class);
    }

    @Nullable
    public GitConfiguration getConfiguration(@NotNull Project project) {
        GitConfiguration gitConfiguration;
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        GitLabProjectConfigurationProperty gitLabProjectConfigurationProperty = (GitLabProjectConfigurationProperty)this.propertyService.getProperty((ProjectEntity)project, GitLabProjectConfigurationPropertyType.class).getValue();
        if (gitLabProjectConfigurationProperty != null) {
            GitLabProjectConfigurationProperty gitLabProjectConfigurationProperty2 = gitLabProjectConfigurationProperty;
            boolean bl = false;
            boolean bl2 = false;
            GitLabProjectConfigurationProperty $this$run = gitLabProjectConfigurationProperty2;
            boolean bl3 = false;
            gitConfiguration = this.getGitConfiguration($this$run);
        } else {
            gitConfiguration = null;
        }
        return gitConfiguration;
    }

    @Nullable
    public GitPullRequest getPullRequest(@NotNull GitConfiguration configuration, int id) {
        GitPullRequest gitPullRequest;
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        if (configuration instanceof GitLabGitConfiguration) {
            GitLabProjectConfigurationProperty gitLabProjectConfigurationProperty = ((GitLabGitConfiguration)configuration).getProperty();
            Intrinsics.checkExpressionValueIsNotNull((Object)gitLabProjectConfigurationProperty, (String)"configuration.property");
            OntrackGitLabClient client = this.ontrackGitLabClientFactory.create(gitLabProjectConfigurationProperty.getConfiguration());
            gitPullRequest = client.getPullRequest(((GitLabGitConfiguration)configuration).getProperty().getRepository(), id);
        } else {
            gitPullRequest = null;
        }
        return gitPullRequest;
    }

    private GitConfiguration getGitConfiguration(GitLabProjectConfigurationProperty property) {
        return new GitLabGitConfiguration(property, this.getConfiguredIssueService(property));
    }

    private ConfiguredIssueService getConfiguredIssueService(GitLabProjectConfigurationProperty property) {
        ConfiguredIssueService configuredIssueService;
        String identifier = property.getIssueServiceConfigurationIdentifier();
        CharSequence charSequence = identifier;
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence) || IssueServiceConfigurationRepresentation.Companion.isSelf(identifier)) {
            configuredIssueService = new ConfiguredIssueService((IssueServiceExtension)this.issueServiceExtension, (IssueServiceConfiguration)new GitLabIssueServiceConfiguration(property.getConfiguration(), property.getRepository()));
        } else {
            ConfiguredIssueService configuredIssueService2 = this.issueServiceRegistry.getConfiguredIssueService(identifier);
            configuredIssueService = configuredIssueService2;
            Intrinsics.checkExpressionValueIsNotNull((Object)configuredIssueService2, (String)"issueServiceRegistry.get\u2026dIssueService(identifier)");
        }
        return configuredIssueService;
    }

    public GitLabConfigurator(@NotNull PropertyService propertyService, @NotNull IssueServiceRegistry issueServiceRegistry, @NotNull GitLabIssueServiceExtension issueServiceExtension, @NotNull OntrackGitLabClientFactory ontrackGitLabClientFactory) {
        Intrinsics.checkParameterIsNotNull((Object)propertyService, (String)"propertyService");
        Intrinsics.checkParameterIsNotNull((Object)issueServiceRegistry, (String)"issueServiceRegistry");
        Intrinsics.checkParameterIsNotNull((Object)((Object)issueServiceExtension), (String)"issueServiceExtension");
        Intrinsics.checkParameterIsNotNull((Object)ontrackGitLabClientFactory, (String)"ontrackGitLabClientFactory");
        this.propertyService = propertyService;
        this.issueServiceRegistry = issueServiceRegistry;
        this.issueServiceExtension = issueServiceExtension;
        this.ontrackGitLabClientFactory = ontrackGitLabClientFactory;
    }

    @Nullable
    public Integer toPullRequestID(@NotNull String key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        return GitConfigurator.DefaultImpls.toPullRequestID((GitConfigurator)this, (String)key);
    }

    @NotNull
    public String toPullRequestKey(int prId) {
        return GitConfigurator.DefaultImpls.toPullRequestKey((GitConfigurator)this, (int)prId);
    }
}

