/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.client;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.nemerosa.ontrack.extension.git.model.GitPullRequest;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientException;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueWrapper;
import org.gitlab4j.api.GitLabApi;
import org.gitlab4j.api.ProjectApi;
import org.gitlab4j.api.models.Issue;
import org.gitlab4j.api.models.MergeRequest;
import org.gitlab4j.api.models.Milestone;
import org.gitlab4j.api.models.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u001a\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00100\u0016H\u0016R\u001b\u0010\u0005\u001a\u00020\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\t\u0010\n\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lnet/nemerosa/ontrack/extension/gitlab/client/DefaultOntrackGitLabClient;", "Lnet/nemerosa/ontrack/extension/gitlab/client/OntrackGitLabClient;", "configuration", "Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabConfiguration;", "(Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabConfiguration;)V", "api", "Lorg/gitlab4j/api/GitLabApi;", "getApi", "()Lorg/gitlab4j/api/GitLabApi;", "api$delegate", "Lkotlin/Lazy;", "logger", "Lorg/slf4j/Logger;", "getIssue", "Lnet/nemerosa/ontrack/extension/gitlab/model/GitLabIssueWrapper;", "repository", "", "id", "", "getPullRequest", "Lnet/nemerosa/ontrack/extension/git/model/GitPullRequest;", "getRepositories", "", "ontrack-extension-gitlab"})
public final class DefaultOntrackGitLabClient
implements OntrackGitLabClient {
    private final Logger logger;
    private final Lazy api$delegate;
    private final GitLabConfiguration configuration;

    private final GitLabApi getApi() {
        Lazy lazy = this.api$delegate;
        DefaultOntrackGitLabClient defaultOntrackGitLabClient = this;
        Object var3_3 = null;
        boolean bl = false;
        return (GitLabApi)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<String> getRepositories() {
        List list;
        this.logger.debug("[gitlab] Getting repository list");
        try {
            void $this$mapTo$iv$iv;
            ProjectApi projectApi = this.getApi().getProjectApi();
            Intrinsics.checkExpressionValueIsNotNull((Object)projectApi, (String)"api.projectApi");
            List list2 = projectApi.getOwnedProjects();
            Intrinsics.checkExpressionValueIsNotNull((Object)list2, (String)"api.projectApi.ownedProjects");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Project project = (Project)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                StringBuilder stringBuilder = new StringBuilder();
                void v3 = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"it");
                String string = stringBuilder.append(v3.getNamespace()).append('/').append(it.getName()).toString();
                collection.add(string);
            }
            list = (List)destination$iv$iv;
        }
        catch (Exception e) {
            throw (Throwable)((Object)new OntrackGitLabClientException(e));
        }
        return list;
    }

    @Override
    @NotNull
    public GitLabIssueWrapper getIssue(@NotNull String repository, int id) {
        GitLabIssueWrapper gitLabIssueWrapper;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        try {
            Issue issue = this.getApi().getIssuesApi().getIssue((Object)repository, Integer.valueOf(id));
            String milestoneUrl = null;
            Issue issue2 = issue;
            Intrinsics.checkExpressionValueIsNotNull((Object)issue2, (String)"issue");
            if (issue2.getMilestone() != null) {
                Milestone milestone = issue.getMilestone();
                milestoneUrl = this.configuration.getUrl() + "/projects/" + repository + "/milestones/" + (milestone != null ? milestone.getId() : null);
            }
            gitLabIssueWrapper = new GitLabIssueWrapper(issue, milestoneUrl);
        }
        catch (Exception e) {
            throw (Throwable)((Object)new OntrackGitLabClientException(e));
        }
        return gitLabIssueWrapper;
    }

    @Override
    @Nullable
    public GitPullRequest getPullRequest(@NotNull String repository, int id) {
        GitPullRequest gitPullRequest;
        Intrinsics.checkParameterIsNotNull((Object)repository, (String)"repository");
        try {
            try {
                MergeRequest pr = this.getApi().getMergeRequestApi().getMergeRequest((Object)repository, Integer.valueOf(id));
                String string = "" + '#' + id;
                MergeRequest mergeRequest = pr;
                Intrinsics.checkExpressionValueIsNotNull((Object)mergeRequest, (String)"pr");
                String string2 = mergeRequest.getSourceBranch();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"pr.sourceBranch");
                String string3 = pr.getTargetBranch();
                Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"pr.targetBranch");
                String string4 = pr.getTitle();
                Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"pr.title");
                String string5 = pr.getState();
                Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"pr.state");
                String string6 = pr.getWebUrl();
                Intrinsics.checkExpressionValueIsNotNull((Object)string6, (String)"pr.webUrl");
                gitPullRequest = new GitPullRequest(id, string, string2, string3, string4, string5, string6);
            }
            catch (FileNotFoundException ignored) {
                gitPullRequest = null;
            }
        }
        catch (IOException e) {
            throw (Throwable)((Object)new OntrackGitLabClientException(e));
        }
        return gitPullRequest;
    }

    public DefaultOntrackGitLabClient(@NotNull GitLabConfiguration configuration) {
        Intrinsics.checkParameterIsNotNull((Object)configuration, (String)"configuration");
        this.configuration = configuration;
        Logger logger = LoggerFactory.getLogger(OntrackGitLabClient.class);
        Intrinsics.checkExpressionValueIsNotNull((Object)logger, (String)"LoggerFactory.getLogger(\u2026GitLabClient::class.java)");
        this.logger = logger;
        this.api$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GitLabApi>(this){
            final /* synthetic */ DefaultOntrackGitLabClient this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final GitLabApi invoke() {
                void var2_2;
                String personalAccessToken = DefaultOntrackGitLabClient.access$getConfiguration$p(this.this$0).getPassword();
                GitLabApi api2 = new GitLabApi(DefaultOntrackGitLabClient.access$getConfiguration$p(this.this$0).getUrl(), personalAccessToken);
                api2.setRequestTimeout(Integer.valueOf(1000), Integer.valueOf(5000));
                api2.setIgnoreCertificateErrors(DefaultOntrackGitLabClient.access$getConfiguration$p(this.this$0).isIgnoreSslCertificate());
                return var2_2;
            }
            {
                this.this$0 = defaultOntrackGitLabClient;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ GitLabConfiguration access$getConfiguration$p(DefaultOntrackGitLabClient $this) {
        return $this.configuration;
    }
}

