"use strict";angular.module("ontrack.extension.gitlab",["ot.service.core","ot.service.configuration","ot.service.form"]).config(["$stateProvider",function(t){t.state("gitlab-configurations",{url:"/extension/gitlab/configurations",templateUrl:"extension/gitlab/gitlab.configurations.tpl.html",controller:"GitLabConfigurationsCtrl"})}]).controller("GitLabConfigurationsCtrl",["$scope","$http","ot","otFormService","otAlertService","otConfigurationService",function(t,i,n,o,e,a){function r(){n.call(i.get("extension/gitlab/configurations")).then(function(i){t.configurations=i,c.commands=[{id:"gitlab-configuration-create",name:"Create a configuration",cls:"ot-command-new",action:t.createConfiguration},n.viewApiCommand(i._self),n.viewCloseCommand("/home")]})}var c=n.view();c.title="GitLab configurations",c.description="Management of the GitLab configurations.",c.commands=[],r(),t.createConfiguration=function(){o.display({uri:t.configurations._create,title:"GitLab configuration",buttons:[a.testButton(t.configurations._test)],submit:function(o){return n.call(i.post(t.configurations._create,o))}}).then(r)},t.deleteConfiguration=function(t){e.confirm({title:"GiLab configuration",message:"Do you really want to delete this GitLab configuration? Some projects may still refer to it."}).then(function(){n.call(i["delete"](t._delete)).then(r)})},t.updateConfiguration=function(e){o.display({uri:e._update,title:"GitLab configuration",buttons:[a.testButton(t.configurations._test)],submit:function(t){return n.call(i.put(e._update,t))}}).then(r)}}]);
angular.module("ontrack-extension-gitlab-templates",[]).run(["$log","$templateCache",function(n,e){n.info("Loading templates for gitlab @ 3.43.11"),e.put("extension/gitlab/changelog.issues.tpl.html",'<table class="table table-hover table-condensed">\n    <thead>\n    <tr>\n        <th>ID</th>\n        <th>State</th>\n        <th>Title</th>\n        <th>Milestone</th>\n        <th>Assignee</th>\n        <th>Updated</th>\n        <th>Labels</th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr ng-repeat="changeLogIssue in value.list">\n        <td>\n            <code><a href="{{changeLogIssue.issue.url}}">{{changeLogIssue.issue.displayKey}}</a></code>\n        </td>\n        <td>\n            <span class="label"\n                    ng-class="{\n                    \'label-success\': (changeLogIssue.issue.status.name == \'opened\'),\n                    \'label-danger\': (changeLogIssue.issue.status.name != \'opened\')\n                    }">\n                {{changeLogIssue.issue.status.name}}\n            </span>\n        </td>\n        <td>\n            <span>{{changeLogIssue.issue.summary}}</span>\n        </td>\n        <td>\n            <a class="label"\n               ng-class="{\n                    \'label-success\': (changeLogIssue.issue.gitlabIssue.milestone.state == \'active\'),\n                    \'label-danger\': (changeLogIssue.issue.gitlabIssue.milestone.state != \'active\')\n                    }"\n               ng-if="changeLogIssue.issue.milestoneUrl" href="{{changeLogIssue.issue.milestoneUrl}}">\n                {{changeLogIssue.issue.gitlabIssue.milestone.title}}\n            </a>\n        </td>\n        <td>\n            {{changeLogIssue.issue.gitlabIssue.assignee.name}}\n        </td>\n        <td>\n            <span>{{changeLogIssue.issue.updateTime | date:\'mediumDate\'}}</span>\n        </td>\n        <td class="ot-label-suite">\n            <span ng-repeat="label in changeLogIssue.issue.gitlabIssue.labels"\n                  class="label label-info">{{label}}</span>\n        </td>\n    </tr>\n    </tbody>\n</table>'),e.put("extension/gitlab/gitlab.configurations.tpl.html",'<ot-view>\n    <div class="row">\n        <div class="col-md-12">\n            <ot-section-title>List of configurations</ot-section-title>\n            <ot-noentry list="configurations.resources">\n                No GitLab configuration has been created yet.\n            </ot-noentry>\n            <table class="table table-hover" ng-show="configurations.resources">\n                <thead>\n                <tr>\n                    <th>Name</th>\n                    <th>URL</th>\n                    <th>&nbsp;</th>\n                </tr>\n                </thead>\n                <tbody>\n                <tr ng-repeat="configuration in configurations.resources" name="{{configuration.name}}">\n                    <td>\n                        <code>{{configuration.name}}</code>\n                    </td>\n                    <td>\n                        <a href="{{configuration.url}}">{{configuration.url}}</a>\n                    </td>\n                    <td>\n                        <span class="ot-command" ng-click="updateConfiguration(configuration)">\n                            <span class="ot-command-update"></span>\n                            Update\n                        </span>\n                        <span class="ot-command" ng-click="deleteConfiguration(configuration)">\n                            <span class="ot-command-delete"></span>\n                            Delete\n                        </span>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</ot-view>'),e.put("extension/gitlab/help.net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration.indexationInterval.tpl.html","Interval (in minutes) between each indexation of the GitLab repository. A value of zero indicates that no indexation\nmust take place automatically and they have to be triggered manually."),e.put("extension/gitlab/issue.tpl.html",'<div ng-if="value.bodyHtml" ng-bind-html="value.bodyHtml" class="well"></div>\n<div>\n    State:\n    <span class="label"\n          ng-class="{\n                    \'label-success\': (value.status.name == \'opened\'),\n                    \'label-danger\': (value.status.name != \'opened\')\n                    }">\n                {{value.status.name}}\n            </span>\n    <span ng-if="value.gitlabIssue.milestone">\n        Milestone:\n        <a class="label"\n           ng-class="{\n                    \'label-success\': (value.gitlabIssue.milestone.state == \'active\'),\n                    \'label-danger\': (value.gitlabIssue.milestone.state != \'active\')\n                    }"\n           ng-if="value.milestoneUrl"\n           href="{{value.milestoneUrl}}">\n                {{value.gitlabIssue.milestone.title}}\n            </a>\n    </span>\n    <span ng-if="value.labels" class="ot-label-suite">\n        Labels:\n        <span ng-repeat="label in value.labels" class="label label-info">{{label}}</span>\n    </span>\n    <span ng-if="value.gitlabIssue.assignee">\n        Assignee:\n        {{value.gitlabIssue.assignee.name}}\n    </span>\n</div>'),e.put("extension/gitlab/decoration/net.nemerosa.ontrack.extension.gitlab.GitLabProjectDecorator.tpl.html",'<img\n        src="extension/gitlab/decoration/gitlab.png"\n        class="ot-icon"\n        title="GitLab repository: {{decoration.data}}"\n/>'),e.put("extension/gitlab/property/net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationPropertyType.tpl.html",'<a href="{{property.value.configuration.url}}/{{property.value.repository}}">\n    {{property.value.repository}}\n    @ {{property.value.configuration.name}}\n</a>')}]);