/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.common.MapBuilder;
import net.nemerosa.ontrack.extension.git.property.AbstractGitProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.gitlab.GitLabExtensionFeature;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.gitlab.service.GitLabConfigurationService;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ConfigurationPropertyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitLabProjectConfigurationPropertyType
extends AbstractGitProjectConfigurationPropertyType<GitLabProjectConfigurationProperty>
implements ConfigurationPropertyType<GitLabConfiguration, GitLabProjectConfigurationProperty> {
    private final GitLabConfigurationService configurationService;
    private final IssueServiceRegistry issueServiceRegistry;

    @Autowired
    public GitLabProjectConfigurationPropertyType(GitLabExtensionFeature extensionFeature, GitLabConfigurationService configurationService, IssueServiceRegistry issueServiceRegistry) {
        super((ExtensionFeature)extensionFeature);
        this.configurationService = configurationService;
        this.issueServiceRegistry = issueServiceRegistry;
    }

    public String getName() {
        return "GitLab configuration";
    }

    public String getDescription() {
        return "Associates the project with a GitLab repository";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, GitLabProjectConfigurationProperty value) {
        ArrayList<IssueServiceConfigurationRepresentation> availableIssueServiceConfigurations = new ArrayList<IssueServiceConfigurationRepresentation>(this.issueServiceRegistry.getAvailableIssueServiceConfigurations());
        availableIssueServiceConfigurations.add(0, IssueServiceConfigurationRepresentation.Companion.self("GitLab issues", "gitlab"));
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"configuration").label("Configuration")).help("GitLab configuration to use to access the repository")).items(this.configurationService.getConfigurationDescriptors()).value(value != null ? value.getConfiguration().getName() : null)).with((Field)((Selection)((Selection)((Selection)Selection.of((String)"issueServiceConfigurationIdentifier").label("Issue configuration")).help("Select an issue service that is used to associate tickets and issues to the source.")).optional()).items(availableIssueServiceConfigurations).value((Object)(value != null ? value.getIssueServiceConfigurationIdentifier() : null))).with((Field)((Text)((Text)((Text)Text.of((String)"repository").label("Repository")).length(100)).regex("[A-Za-z0-9_\\.\\-]+").validation("Repository is required and must be a GitLab repository (account/repository).")).value((Object)(value != null ? value.getRepository() : null))).with((Field)((Int)((Int)Int.of((String)"indexationInterval").label("Indexation interval")).min(0).max(1440).value((Object)(value != null ? value.getIndexationInterval() : 0))).help("@file:extension/gitlab/help.net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration.indexationInterval.tpl.html"));
    }

    public GitLabProjectConfigurationProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public GitLabProjectConfigurationProperty fromStorage(JsonNode node) {
        String configurationName = node.path("configuration").asText();
        GitLabConfiguration configuration = (GitLabConfiguration)this.configurationService.getConfiguration(configurationName);
        return new GitLabProjectConfigurationProperty(configuration, JsonUtils.get((JsonNode)node, (String)"issueServiceConfigurationIdentifier", null), node.path("repository").asText(), node.path("indexationInterval").asInt());
    }

    public JsonNode forStorage(GitLabProjectConfigurationProperty value) {
        return GitLabProjectConfigurationPropertyType.format((Object)MapBuilder.params().with((Object)"configuration", (Object)value.getConfiguration().getName()).with((Object)"repository", (Object)value.getRepository()).with((Object)"indexationInterval", (Object)value.getIndexationInterval()).with((Object)"issueServiceConfigurationIdentifier", (Object)value.getIssueServiceConfigurationIdentifier()).get());
    }

    public String getSearchKey(GitLabProjectConfigurationProperty value) {
        return value.getConfiguration().getName();
    }

    public GitLabProjectConfigurationProperty replaceValue(GitLabProjectConfigurationProperty value, Function<String, String> replacementFunction) {
        return new GitLabProjectConfigurationProperty((GitLabConfiguration)this.configurationService.replaceConfiguration(value.getConfiguration(), replacementFunction), value.getIssueServiceConfigurationIdentifier(), replacementFunction.apply(value.getRepository()), value.getIndexationInterval());
    }
}

