/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.property;

import java.util.Optional;
import net.nemerosa.ontrack.extension.git.model.GitConfiguration;
import net.nemerosa.ontrack.extension.git.model.GitConfigurator;
import net.nemerosa.ontrack.extension.gitlab.GitLabIssueServiceExtension;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabGitConfiguration;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.gitlab.property.GitLabProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitLabConfigurator
implements GitConfigurator {
    private final PropertyService propertyService;
    private final IssueServiceRegistry issueServiceRegistry;
    private final GitLabIssueServiceExtension issueServiceExtension;

    @Autowired
    public GitLabConfigurator(PropertyService propertyService, IssueServiceRegistry issueServiceRegistry, GitLabIssueServiceExtension issueServiceExtension) {
        this.propertyService = propertyService;
        this.issueServiceRegistry = issueServiceRegistry;
        this.issueServiceExtension = issueServiceExtension;
    }

    public boolean isProjectConfigured(@NotNull Project project) {
        return this.propertyService.hasProperty((ProjectEntity)project, GitLabProjectConfigurationPropertyType.class);
    }

    public Optional<GitConfiguration> getConfiguration(Project project) {
        return this.propertyService.getProperty((ProjectEntity)project, GitLabProjectConfigurationPropertyType.class).option().map(this::getGitConfiguration);
    }

    private GitConfiguration getGitConfiguration(GitLabProjectConfigurationProperty property) {
        return new GitLabGitConfiguration(property, this.getConfiguredIssueService(property));
    }

    private ConfiguredIssueService getConfiguredIssueService(GitLabProjectConfigurationProperty property) {
        String identifier = property.getIssueServiceConfigurationIdentifier();
        if (IssueServiceConfigurationRepresentation.isSelf((String)identifier)) {
            return new ConfiguredIssueService((IssueServiceExtension)this.issueServiceExtension, (IssueServiceConfiguration)new GitLabIssueServiceConfiguration(property.getConfiguration(), property.getRepository()));
        }
        return this.issueServiceRegistry.getConfiguredIssueService(identifier);
    }
}

