/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.client;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientException;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueWrapper;
import org.gitlab.api.GitlabAPI;
import org.gitlab.api.TokenType;
import org.gitlab.api.models.GitlabIssue;
import org.gitlab.api.models.GitlabProject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOntrackGitLabClient
implements OntrackGitLabClient {
    private final Logger logger = LoggerFactory.getLogger(OntrackGitLabClient.class);
    private final GitlabAPI api;
    private final GitLabConfiguration configuration;

    public DefaultOntrackGitLabClient(GitLabConfiguration configuration) throws IOException {
        this.configuration = configuration;
        String personalAccessToken = configuration.getPassword();
        GitlabAPI api = GitlabAPI.connect((String)configuration.getUrl(), (String)personalAccessToken, (TokenType)TokenType.PRIVATE_TOKEN);
        this.api = configuration.isIgnoreSslCertificate() ? api.ignoreCertificateErrors(true) : api;
    }

    @Override
    public List<String> getRepositories() {
        this.logger.debug("[gitlab] Getting repository list");
        try {
            return this.api.getProjects().stream().map(GitlabProject::getNameWithNamespace).collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new OntrackGitLabClientException(e);
        }
    }

    @Override
    public GitLabIssueWrapper getIssue(String repository, int id) {
        try {
            String issueUrl = this.configuration.getUrl() + "/" + repository + "/issues" + "/" + id;
            GitlabIssue issue = this.api.getIssue((Serializable)((Object)repository), Integer.valueOf(id));
            String milestoneUrl = null;
            if (issue.getMilestone() != null) {
                milestoneUrl = this.configuration.getUrl() + "/" + repository + "/milestones" + "/" + issue.getMilestone().getId();
            }
            return GitLabIssueWrapper.of(issue, milestoneUrl, issueUrl);
        }
        catch (Exception e) {
            throw new OntrackGitLabClientException(e);
        }
    }
}

