/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.model;

import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabIssueStatusWrapper;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueStatus;
import org.gitlab.api.models.GitlabIssue;

public class GitLabIssueWrapper
implements Issue {
    private final GitlabIssue gitlabIssue;
    private final String milestoneUrl;
    private final String issueUrl;

    public String getKey() {
        return String.valueOf(this.gitlabIssue.getId());
    }

    public String getDisplayKey() {
        return "#" + this.gitlabIssue.getId();
    }

    public String getSummary() {
        return this.gitlabIssue.getTitle();
    }

    public String getUrl() {
        return this.issueUrl;
    }

    public IssueStatus getStatus() {
        return new GitLabIssueStatusWrapper(this.gitlabIssue.getState());
    }

    public LocalDateTime getUpdateTime() {
        return Time.from((Date)this.gitlabIssue.getUpdatedAt(), null);
    }

    public static GitLabIssueWrapper of(GitlabIssue issue, String milestoneUrl, String issueUrl) {
        return new GitLabIssueWrapper(issue, milestoneUrl, issueUrl);
    }

    public List<String> getLabels() {
        return Arrays.asList(this.gitlabIssue.getLabels());
    }

    @ConstructorProperties(value={"gitlabIssue", "milestoneUrl", "issueUrl"})
    public GitLabIssueWrapper(GitlabIssue gitlabIssue, String milestoneUrl, String issueUrl) {
        this.gitlabIssue = gitlabIssue;
        this.milestoneUrl = milestoneUrl;
        this.issueUrl = issueUrl;
    }

    public GitlabIssue getGitlabIssue() {
        return this.gitlabIssue;
    }

    public String getMilestoneUrl() {
        return this.milestoneUrl;
    }

    public String getIssueUrl() {
        return this.issueUrl;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitLabIssueWrapper)) {
            return false;
        }
        GitLabIssueWrapper other = (GitLabIssueWrapper)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GitlabIssue this$gitlabIssue = this.getGitlabIssue();
        GitlabIssue other$gitlabIssue = other.getGitlabIssue();
        if (this$gitlabIssue == null ? other$gitlabIssue != null : !this$gitlabIssue.equals(other$gitlabIssue)) {
            return false;
        }
        String this$milestoneUrl = this.getMilestoneUrl();
        String other$milestoneUrl = other.getMilestoneUrl();
        if (this$milestoneUrl == null ? other$milestoneUrl != null : !this$milestoneUrl.equals(other$milestoneUrl)) {
            return false;
        }
        String this$issueUrl = this.getIssueUrl();
        String other$issueUrl = other.getIssueUrl();
        return !(this$issueUrl == null ? other$issueUrl != null : !this$issueUrl.equals(other$issueUrl));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitLabIssueWrapper;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GitlabIssue $gitlabIssue = this.getGitlabIssue();
        result = result * 59 + ($gitlabIssue == null ? 43 : $gitlabIssue.hashCode());
        String $milestoneUrl = this.getMilestoneUrl();
        result = result * 59 + ($milestoneUrl == null ? 43 : $milestoneUrl.hashCode());
        String $issueUrl = this.getIssueUrl();
        result = result * 59 + ($issueUrl == null ? 43 : $issueUrl.hashCode());
        return result;
    }

    public String toString() {
        return "GitLabIssueWrapper(gitlabIssue=" + this.getGitlabIssue() + ", milestoneUrl=" + this.getMilestoneUrl() + ", issueUrl=" + this.getIssueUrl() + ")";
    }
}

