/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.UserPassword;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;

public class GitLabConfiguration
implements UserPasswordConfiguration<GitLabConfiguration> {
    private final String name;
    private final String url;
    private final String user;
    private final String password;
    private final boolean ignoreSslCertificate;

    @ConstructorProperties(value={"name", "url", "user", "password", "ignoreSslCertificate"})
    public GitLabConfiguration(String name, String url, String user, String password, boolean ignoreSslCertificate) {
        this.name = name;
        this.url = url;
        this.user = user;
        this.password = password;
        this.ignoreSslCertificate = ignoreSslCertificate;
    }

    @JsonIgnore
    public ConfigurationDescriptor getDescriptor() {
        return new ConfigurationDescriptor(this.name, String.format("%s (%s)", this.name, this.url));
    }

    public GitLabConfiguration obfuscate() {
        return this.withPassword("");
    }

    public GitLabConfiguration withPassword(String password) {
        return new GitLabConfiguration(this.name, this.url, this.user, password, this.ignoreSslCertificate);
    }

    public static Form form() {
        return Form.create().with((Field)Form.defaultNameField()).with((Field)((Text)((Text)Text.of((String)"url").label("URL")).length(250)).help("URL of the GitLab engine.")).with((Field)((Text)Text.of((String)"user").label("User")).length(16)).with((Field)((Password)Password.of((String)"password").label("Personal Access Token")).length(50)).with((Field)YesNo.of((String)"ignoreSslCertificate").label("Ignore SSL certificate"));
    }

    public Form asForm() {
        return GitLabConfiguration.form().with((Field)((Text)Form.defaultNameField().readOnly()).value((Object)this.name)).fill("url", (Object)this.url).fill("user", (Object)this.user).fill("ignoreSslCertificate", (Object)this.ignoreSslCertificate);
    }

    public GitLabConfiguration clone(String targetConfigurationName, Function<String, String> replacementFunction) {
        return new GitLabConfiguration(targetConfigurationName, replacementFunction.apply(this.url), replacementFunction.apply(this.user), this.password, this.ignoreSslCertificate);
    }

    public Optional<UserPassword> getCredentials() {
        return Optional.of(new UserPassword(this.user, this.password));
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public boolean isIgnoreSslCertificate() {
        return this.ignoreSslCertificate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitLabConfiguration)) {
            return false;
        }
        GitLabConfiguration other = (GitLabConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        return this.isIgnoreSslCertificate() == other.isIgnoreSslCertificate();
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitLabConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        result = result * 59 + (this.isIgnoreSslCertificate() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "GitLabConfiguration(name=" + this.getName() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", ignoreSslCertificate=" + this.isIgnoreSslCertificate() + ")";
    }
}

