/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab.resource;

import java.util.List;
import net.nemerosa.ontrack.extension.gitlab.GitLabController;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.resource.AbstractResourceDecorator;
import net.nemerosa.ontrack.ui.resource.Link;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@Component
public class GitLabConfigurationResourceDecorator
extends AbstractResourceDecorator<GitLabConfiguration> {
    private final SecurityService securityService;

    @Autowired
    public GitLabConfigurationResourceDecorator(SecurityService securityService) {
        super(GitLabConfiguration.class);
        this.securityService = securityService;
    }

    public GitLabConfiguration decorateBeforeSerialization(GitLabConfiguration bean) {
        return bean.obfuscate();
    }

    public List<Link> links(GitLabConfiguration configuration, ResourceContext resourceContext) {
        boolean globalSettingsGranted = this.securityService.isGlobalFunctionGranted(GlobalSettings.class);
        return resourceContext.links().self((Object)((GitLabController)((Object)MvcUriComponentsBuilder.on(GitLabController.class))).getConfiguration(configuration.getName())).link("_update", (Object)((GitLabController)((Object)MvcUriComponentsBuilder.on(GitLabController.class))).updateConfigurationForm(configuration.getName()), globalSettingsGranted).link("_delete", (Object)((GitLabController)((Object)MvcUriComponentsBuilder.on(GitLabController.class))).deleteConfiguration(configuration.getName()), globalSettingsGranted).build();
    }
}

