/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.gitlab;

import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClient;
import net.nemerosa.ontrack.extension.gitlab.client.OntrackGitLabClientFactory;
import net.nemerosa.ontrack.extension.gitlab.model.GitLabConfiguration;
import net.nemerosa.ontrack.extension.support.ConfigurationHealthIndicator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.stereotype.Component;

@Component
public class GitLabHealthIndicator
extends ConfigurationHealthIndicator<GitLabConfiguration> {
    private final OntrackGitLabClientFactory gitLabClientFactory;

    @Autowired
    public GitLabHealthIndicator(ConfigurationService<GitLabConfiguration> configurationService, SecurityService securityService, HealthAggregator healthAggregator, OntrackGitLabClientFactory gitLabClientFactory) {
        super(configurationService, securityService, healthAggregator);
        this.gitLabClientFactory = gitLabClientFactory;
    }

    protected Health getHealth(GitLabConfiguration config) {
        try {
            OntrackGitLabClient client = this.gitLabClientFactory.create(config);
            client.getRepositories();
            return Health.up().build();
        }
        catch (Exception ex) {
            return Health.down((Exception)ex).build();
        }
    }
}

