angular.module("ontrack.extension.github",["ot.service.core","ot.service.configuration","ot.service.form"]).config(["$stateProvider",function(t){t.state("github-configurations",{url:"/extension/github/configurations",templateUrl:"extension/github/github.configurations.tpl.html",controller:"GitHubConfigurationsCtrl"})}]).controller("GitHubConfigurationsCtrl",["$scope","$http","ot","otFormService","otAlertService","otConfigurationService",function(t,i,n,o,e,u){function r(){n.call(i.get("extension/github/configurations")).then(function(i){t.configurations=i,a.commands=[{id:"github-configuration-create",name:"Create a configuration",cls:"ot-command-new",action:t.createConfiguration},n.viewApiCommand(i._self),n.viewCloseCommand("/home")]})}var a=n.view();a.title="GitHub configurations",a.description="Management of the GitHub configurations.",a.commands=[],r(),t.createConfiguration=function(){o.display({uri:t.configurations._create,title:"GitHub configuration",buttons:[u.testButton(t.configurations._test)],submit:function(o){return n.call(i.post(t.configurations._create,o))}}).then(r)},t.deleteConfiguration=function(t){e.confirm({title:"GitHub configuration",message:"Do you really want to delete this GitHub configuration? Some projects may still refer to it."}).then(function(){n.call(i["delete"](t._delete)).then(r)})},t.updateConfiguration=function(e){o.display({uri:e._update,title:"GitHub configuration",buttons:[u.testButton(t.configurations._test)],submit:function(t){return n.call(i.put(e._update,t))}}).then(r)}}]);
angular.module("ontrack-extension-github-templates",[]).run(["$log","$templateCache",function(n,e){n.info("Loading templates for github @ experimental-pipeline-3de589d"),e.put("extension/github/changelog.issues.tpl.html",'<table class="table table-hover table-condensed">\n    <thead>\n    <tr>\n        <th>ID</th>\n        <th>State</th>\n        <th>Title</th>\n        <th>Milestone</th>\n        <th>Assignee</th>\n        <th>Updated</th>\n        <th>Labels</th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr ng-repeat="changeLogIssue in value.list">\n        <td>\n            <code><a href="{{changeLogIssue.issue.url}}">{{changeLogIssue.issue.displayKey}}</a></code>\n        </td>\n        <td>\n            <span class="label"\n                    ng-class="{\n                    \'label-success\': (changeLogIssue.issue.state == \'open\'),\n                    \'label-danger\': (changeLogIssue.issue.state != \'open\')\n                    }">\n                {{changeLogIssue.issue.state}}\n            </span>\n        </td>\n        <td>\n            <span>{{changeLogIssue.issue.title}}</span>\n        </td>\n        <td>\n            <a class="label"\n               ng-class="{\n                    \'label-success\': (changeLogIssue.issue.milestone.state == \'open\'),\n                    \'label-danger\': (changeLogIssue.issue.milestone.state != \'open\')\n                    }"\n               ng-if="changeLogIssue.issue.milestone" href="{{changeLogIssue.issue.milestone.url}}">\n                {{changeLogIssue.issue.milestone.title}}\n            </a>\n        </td>\n        <td>\n            <a ng-if="changeLogIssue.issue.assignee" href="{{changeLogIssue.issue.assignee.url}}">{{changeLogIssue.issue.assignee.login}}</a>\n        </td>\n        <td>\n            <span>{{changeLogIssue.issue.updatedAt | date:\'mediumDate\'}}</span>\n        </td>\n        <td class="ot-label-suite">\n            <span ng-repeat="label in changeLogIssue.issue.labels"\n                  class="label label-info"\n                  ng-style="{\'background-color\': \'#\' + label.color + \' !important\'}"\n                    >{{label.name}}</span>\n        </td>\n    </tr>\n    </tbody>\n</table>'),e.put("extension/github/github.configurations.tpl.html",'<ot-view>\n    <div class="row">\n        <div class="col-md-12">\n            <ot-section-title>List of configurations</ot-section-title>\n            <ot-noentry list="configurations.resources">\n                No GitHub configuration has been created yet.\n            </ot-noentry>\n            <table class="table table-hover" ng-show="configurations.resources">\n                <thead>\n                <tr>\n                    <th>Name</th>\n                    <th>URL</th>\n                    <th>User</th>\n                    <th>&nbsp;</th>\n                </tr>\n                </thead>\n                <tbody>\n                <tr ng-repeat="configuration in configurations.resources" name="{{configuration.name}}">\n                    <td>\n                        <code>{{configuration.name}}</code>\n                    </td>\n                    <td>\n                        <a href="{{configuration.url}}">{{configuration.url}}</a>\n                    </td>\n                    <td>\n                        <span ng-if="configuration.user">\n                            {{configuration.user}}\n                        </span>\n                        <span ng-if="!configuration.user" class="ot-description">\n                            No user\n                        </span>\n                    </td>\n                    <td>\n                        <span class="ot-command" ng-click="updateConfiguration(configuration)">\n                            <span class="ot-command-update"></span>\n                            Update\n                        </span>\n                        <span class="ot-command" ng-click="deleteConfiguration(configuration)">\n                            <span class="ot-command-delete"></span>\n                            Delete\n                        </span>\n                    </td>\n                </tr>\n                </tbody>\n            </table>\n        </div>\n    </div>\n</ot-view>'),e.put("extension/github/help.net.nemerosa.ontrack.extension.github.model.GitHubConfiguration.indexationInterval.tpl.html","Interval (in minutes) between each indexation of the GitHub repository. A value of zero indicates that no indexation\nmust take place automatically and they have to be triggered manually."),e.put("extension/github/issue.tpl.html",'<div ng-if="value.bodyHtml" ng-bind-html="value.bodyHtml" class="well"></div>\n<div>\n    State:\n    <span class="ot-extension-github-state ot-extension-github-state-{{value.state}}">{{value.state}}</span>\n    <span ng-if="value.milestone">\n        Milestone:\n        <a class="ot-extension-github-state ot-extension-github-state-{{value.milestone.state}}" ng-if="value.milestone" href="{{value.milestone.url}}">{{value.milestone.title}}</a>\n    </span>\n    <span ng-if="value.labels">\n        Labels:\n        <span ng-repeat="label in value.labels" class="ot-extension-github-label">{{label.name}}</span>\n    </span>\n    <span ng-if="value.assignee">\n        Assignee:\n        <a ng-if="value.assignee" href="{{value.assignee.url}}" target="_blank" class="label label-default">\n            {{value.assignee.login}}\n        </a>\n    </span>\n</div>'),e.put("extension/github/decoration/net.nemerosa.ontrack.extension.github.GitHubProjectDecorator.tpl.html",'<img\n        src="extension/github/decoration/github.png"\n        class="ot-icon"\n        title="GitHub repository: {{decoration.data}}"\n/>'),e.put("extension/github/property/net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationPropertyType.tpl.html",'<a href="{{property.value.configuration.url}}/{{property.value.repository}}">\n    {{property.value.repository}}\n    @ {{property.value.configuration.name}}\n</a>')}]);