/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.support;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.beans.ConstructorProperties;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import net.nemerosa.ontrack.extension.github.model.GitHubEngineConfiguration;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationPropertyType;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.json.ObjectMapperFactory;
import net.nemerosa.ontrack.model.support.DBMigrationAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class GitHubEngineConfigurationMigrationAction
implements DBMigrationAction {
    public static final int GITHUB_ENGINE_PATCH = 18;
    private final Logger logger = LoggerFactory.getLogger(GitHubEngineConfigurationMigrationAction.class);
    private final ObjectMapper objectMapper = ObjectMapperFactory.create();

    public int getPatch() {
        return 18;
    }

    public void migrate(Connection connection) throws Exception {
        Map<String, OldConfiguration> oldConfigurations = this.migrateConfigurations(connection);
        this.migrateProjects(connection, oldConfigurations);
    }

    private void migrateProjects(Connection connection, Map<String, OldConfiguration> oldConfigurations) throws SQLException, IOException {
        try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM PROPERTIES WHERE TYPE = ?", 1003, 1008);){
            ps.setString(1, GitHubProjectConfigurationPropertyType.class.getName());
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String json = rs.getString("JSON");
                    ObjectNode node = (ObjectNode)this.objectMapper.readTree(json);
                    String configurationName = JsonUtils.get((JsonNode)node, (String)"configuration");
                    OldConfiguration oldConfiguration = oldConfigurations.get(configurationName);
                    if (oldConfiguration == null) {
                        throw new IllegalStateException("Could not find GitHub configuration with name " + configurationName);
                    }
                    node.put("repository", oldConfiguration.getRepository());
                    node.put("indexationInterval", oldConfiguration.getIndexationInterval());
                    rs.updateString("JSON", this.objectMapper.writeValueAsString((Object)node));
                    rs.updateRow();
                }
            }
        }
    }

    private Map<String, OldConfiguration> migrateConfigurations(Connection connection) throws Exception {
        HashMap<String, OldConfiguration> oldConfigurations = new HashMap<String, OldConfiguration>();
        try (PreparedStatement ps = connection.prepareStatement("SELECT * FROM CONFIGURATIONS WHERE TYPE = ?", 1003, 1008);){
            ps.setString(1, "net.nemerosa.ontrack.extension.github.model.GitHubConfiguration");
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    String name = rs.getString("NAME");
                    this.logger.info("Migrating GitHub configuration: {}", (Object)name);
                    String json = rs.getString("CONTENT");
                    OldConfiguration oldConfiguration = (OldConfiguration)this.objectMapper.readValue(json, OldConfiguration.class);
                    GitHubEngineConfiguration newConfiguration = new GitHubEngineConfiguration(oldConfiguration.getName(), "https://github.com", oldConfiguration.getUser(), oldConfiguration.getPassword(), oldConfiguration.getOauth2Token());
                    rs.updateString("TYPE", GitHubEngineConfiguration.class.getName());
                    rs.updateString("CONTENT", this.objectMapper.writeValueAsString((Object)newConfiguration));
                    rs.updateRow();
                    oldConfigurations.put(oldConfiguration.getName(), oldConfiguration);
                }
            }
        }
        return oldConfigurations;
    }

    public String getDisplayName() {
        return "GitHub configuration engine migration";
    }

    public static class OldConfiguration {
        private final String name;
        private final String repository;
        private final String user;
        private final String password;
        private final String oauth2Token;
        private final int indexationInterval;

        @ConstructorProperties(value={"name", "repository", "user", "password", "oauth2Token", "indexationInterval"})
        public OldConfiguration(String name, String repository, String user, String password, String oauth2Token, int indexationInterval) {
            this.name = name;
            this.repository = repository;
            this.user = user;
            this.password = password;
            this.oauth2Token = oauth2Token;
            this.indexationInterval = indexationInterval;
        }

        public String getName() {
            return this.name;
        }

        public String getRepository() {
            return this.repository;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public String getOauth2Token() {
            return this.oauth2Token;
        }

        public int getIndexationInterval() {
            return this.indexationInterval;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof OldConfiguration)) {
                return false;
            }
            OldConfiguration other = (OldConfiguration)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$repository = this.getRepository();
            String other$repository = other.getRepository();
            if (this$repository == null ? other$repository != null : !this$repository.equals(other$repository)) {
                return false;
            }
            String this$user = this.getUser();
            String other$user = other.getUser();
            if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
                return false;
            }
            String this$password = this.getPassword();
            String other$password = other.getPassword();
            if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
                return false;
            }
            String this$oauth2Token = this.getOauth2Token();
            String other$oauth2Token = other.getOauth2Token();
            if (this$oauth2Token == null ? other$oauth2Token != null : !this$oauth2Token.equals(other$oauth2Token)) {
                return false;
            }
            return this.getIndexationInterval() == other.getIndexationInterval();
        }

        protected boolean canEqual(Object other) {
            return other instanceof OldConfiguration;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $repository = this.getRepository();
            result = result * 59 + ($repository == null ? 43 : $repository.hashCode());
            String $user = this.getUser();
            result = result * 59 + ($user == null ? 43 : $user.hashCode());
            String $password = this.getPassword();
            result = result * 59 + ($password == null ? 43 : $password.hashCode());
            String $oauth2Token = this.getOauth2Token();
            result = result * 59 + ($oauth2Token == null ? 43 : $oauth2Token.hashCode());
            result = result * 59 + this.getIndexationInterval();
            return result;
        }

        public String toString() {
            return "GitHubEngineConfigurationMigrationAction.OldConfiguration(name=" + this.getName() + ", repository=" + this.getRepository() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", oauth2Token=" + this.getOauth2Token() + ", indexationInterval=" + this.getIndexationInterval() + ")";
        }
    }
}

