/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.resource;

import java.util.List;
import net.nemerosa.ontrack.extension.github.GitHubController;
import net.nemerosa.ontrack.extension.github.model.GitHubEngineConfiguration;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.resource.AbstractResourceDecorator;
import net.nemerosa.ontrack.ui.resource.Link;
import net.nemerosa.ontrack.ui.resource.ResourceContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@Component
public class GitHubEngineConfigurationResourceDecorator
extends AbstractResourceDecorator<GitHubEngineConfiguration> {
    private final SecurityService securityService;

    @Autowired
    public GitHubEngineConfigurationResourceDecorator(SecurityService securityService) {
        super(GitHubEngineConfiguration.class);
        this.securityService = securityService;
    }

    public GitHubEngineConfiguration decorateBeforeSerialization(GitHubEngineConfiguration bean) {
        return bean.obfuscate();
    }

    public List<Link> links(GitHubEngineConfiguration configuration, ResourceContext resourceContext) {
        boolean globalSettingsGranted = this.securityService.isGlobalFunctionGranted(GlobalSettings.class);
        return resourceContext.links().self((Object)((GitHubController)((Object)MvcUriComponentsBuilder.on(GitHubController.class))).getConfiguration(configuration.getName())).link("_update", (Object)((GitHubController)((Object)MvcUriComponentsBuilder.on(GitHubController.class))).updateConfigurationForm(configuration.getName()), globalSettingsGranted).link("_delete", (Object)((GitHubController)((Object)MvcUriComponentsBuilder.on(GitHubController.class))).deleteConfiguration(configuration.getName()), globalSettingsGranted).build();
    }
}

