/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.property;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.common.MapBuilder;
import net.nemerosa.ontrack.extension.git.property.AbstractGitProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.github.GitHubExtensionFeature;
import net.nemerosa.ontrack.extension.github.model.GitHubEngineConfiguration;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.github.service.GitHubConfigurationService;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Int;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.ConfigurationPropertyType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitHubProjectConfigurationPropertyType
extends AbstractGitProjectConfigurationPropertyType<GitHubProjectConfigurationProperty>
implements ConfigurationPropertyType<GitHubEngineConfiguration, GitHubProjectConfigurationProperty> {
    private final GitHubConfigurationService configurationService;
    private final IssueServiceRegistry issueServiceRegistry;

    @Autowired
    public GitHubProjectConfigurationPropertyType(GitHubExtensionFeature extensionFeature, GitHubConfigurationService configurationService, IssueServiceRegistry issueServiceRegistry) {
        super((ExtensionFeature)extensionFeature);
        this.configurationService = configurationService;
        this.issueServiceRegistry = issueServiceRegistry;
    }

    public String getName() {
        return "GitHub configuration";
    }

    public String getDescription() {
        return "Associates the project with a GitHub repository";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity.projectId(), ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, GitHubProjectConfigurationProperty value) {
        ArrayList<IssueServiceConfigurationRepresentation> availableIssueServiceConfigurations = new ArrayList<IssueServiceConfigurationRepresentation>(this.issueServiceRegistry.getAvailableIssueServiceConfigurations());
        availableIssueServiceConfigurations.add(0, IssueServiceConfigurationRepresentation.self((String)"GitHub issues", (String)"github"));
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"configuration").label("Configuration")).help("GitHub configuration to use to access the repository")).items(this.configurationService.getConfigurationDescriptors()).value(value != null ? value.getConfiguration().getName() : null)).with((Field)((Text)((Text)((Text)Text.of((String)"repository").label("Repository")).length(100)).regex("[A-Za-z0-9_\\.\\-]+").validation("Repository is required and must be a GitHub repository (account/repository).")).value((Object)(value != null ? value.getRepository() : null))).with((Field)((Int)((Int)Int.of((String)"indexationInterval").label("Indexation interval")).min(0).max(1440).value((Object)(value != null ? value.getIndexationInterval() : 0))).help("@file:extension/github/help.net.nemerosa.ontrack.extension.github.model.GitHubConfiguration.indexationInterval.tpl.html")).with((Field)((Selection)((Selection)((Selection)Selection.of((String)"issueServiceConfigurationIdentifier").label("Issue configuration")).help("Select an issue service that is used to associate tickets and issues to the source. If none is selected, the GitHub issues for this repository are used.")).optional()).items(availableIssueServiceConfigurations).value((Object)(value != null ? value.getIssueServiceConfigurationIdentifier() : null)));
    }

    public GitHubProjectConfigurationProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public GitHubProjectConfigurationProperty fromStorage(JsonNode node) {
        String configurationName = node.path("configuration").asText();
        GitHubEngineConfiguration configuration = (GitHubEngineConfiguration)this.configurationService.getConfiguration(configurationName);
        return new GitHubProjectConfigurationProperty(configuration, node.path("repository").asText(), node.path("indexationInterval").asInt(), node.path("issueServiceConfigurationIdentifier").asText());
    }

    public JsonNode forStorage(GitHubProjectConfigurationProperty value) {
        return GitHubProjectConfigurationPropertyType.format((Object)MapBuilder.params().with((Object)"configuration", (Object)value.getConfiguration().getName()).with((Object)"repository", (Object)value.getRepository()).with((Object)"indexationInterval", (Object)value.getIndexationInterval()).with((Object)"issueServiceConfigurationIdentifier", (Object)value.getIssueServiceConfigurationIdentifier()).get());
    }

    public String getSearchKey(GitHubProjectConfigurationProperty value) {
        return value.getConfiguration().getName();
    }

    public GitHubProjectConfigurationProperty replaceValue(GitHubProjectConfigurationProperty value, Function<String, String> replacementFunction) {
        return new GitHubProjectConfigurationProperty((GitHubEngineConfiguration)this.configurationService.replaceConfiguration(value.getConfiguration(), replacementFunction), replacementFunction.apply(value.getRepository()), value.getIndexationInterval(), value.getIssueServiceConfigurationIdentifier());
    }
}

