/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.property;

import java.util.Optional;
import net.nemerosa.ontrack.extension.git.model.GitConfiguration;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.model.support.UserPassword;

public class GitHubGitConfiguration
implements GitConfiguration {
    public static final String CONFIGURATION_REPOSITORY_SEPARATOR = ":";
    private final GitHubProjectConfigurationProperty property;
    private final ConfiguredIssueService configuredIssueService;

    public GitHubGitConfiguration(GitHubProjectConfigurationProperty property, ConfiguredIssueService configuredIssueService) {
        this.property = property;
        this.configuredIssueService = configuredIssueService;
    }

    public String getType() {
        return "github";
    }

    public String getName() {
        return this.property.getConfiguration().getName();
    }

    public String getRemote() {
        return String.format("%s/%s.git", this.property.getConfiguration().getUrl(), this.property.getRepository());
    }

    public Optional<UserPassword> getCredentials() {
        return this.property.getConfiguration().getCredentials();
    }

    public String getCommitLink() {
        return String.format("%s/%s/commit/{commit}", this.property.getConfiguration().getUrl(), this.property.getRepository());
    }

    public String getFileAtCommitLink() {
        return String.format("%s/%s/blob/{commit}/{path}", this.property.getConfiguration().getUrl(), this.property.getRepository());
    }

    public int getIndexationInterval() {
        return this.property.getIndexationInterval();
    }

    public Optional<ConfiguredIssueService> getConfiguredIssueService() {
        return Optional.ofNullable(this.configuredIssueService);
    }
}

