/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.property;

import java.util.Optional;
import net.nemerosa.ontrack.extension.git.model.GitConfiguration;
import net.nemerosa.ontrack.extension.git.model.GitConfigurator;
import net.nemerosa.ontrack.extension.github.GitHubIssueServiceExtension;
import net.nemerosa.ontrack.extension.github.property.GitHubGitConfiguration;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.github.service.GitHubIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationIdentifier;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.structure.Project;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitHubConfigurator
implements GitConfigurator {
    private final PropertyService propertyService;
    private final IssueServiceRegistry issueServiceRegistry;
    private final GitHubIssueServiceExtension issueServiceExtension;

    @Autowired
    public GitHubConfigurator(PropertyService propertyService, IssueServiceRegistry issueServiceRegistry, GitHubIssueServiceExtension issueServiceExtension) {
        this.propertyService = propertyService;
        this.issueServiceRegistry = issueServiceRegistry;
        this.issueServiceExtension = issueServiceExtension;
    }

    public Optional<GitConfiguration> getConfiguration(Project project) {
        return this.propertyService.getProperty((ProjectEntity)project, GitHubProjectConfigurationPropertyType.class).option().map(this::getGitConfiguration);
    }

    private GitConfiguration getGitConfiguration(GitHubProjectConfigurationProperty property) {
        return new GitHubGitConfiguration(property, this.getConfiguredIssueService(property));
    }

    private ConfiguredIssueService getConfiguredIssueService(GitHubProjectConfigurationProperty property) {
        String identifier = property.getIssueServiceConfigurationIdentifier();
        if (StringUtils.isBlank((CharSequence)identifier) || IssueServiceConfigurationRepresentation.isSelf((String)identifier)) {
            return new ConfiguredIssueService((IssueServiceExtension)this.issueServiceExtension, (IssueServiceConfiguration)new GitHubIssueServiceConfiguration(property.getConfiguration(), property.getRepository()));
        }
        return this.issueServiceRegistry.getConfiguredIssueService(new IssueServiceConfigurationIdentifier("github", property.getConfiguration().getName() + ":" + property.getRepository()).format());
    }
}

