/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.time.LocalDateTime;
import java.util.List;
import net.nemerosa.ontrack.extension.github.model.GitHubIssueStatus;
import net.nemerosa.ontrack.extension.github.model.GitHubLabel;
import net.nemerosa.ontrack.extension.github.model.GitHubMilestone;
import net.nemerosa.ontrack.extension.github.model.GitHubState;
import net.nemerosa.ontrack.extension.github.model.GitHubUser;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueStatus;

public class GitHubIssue
implements Issue {
    private final int id;
    private final String url;
    private final String title;
    private final String body;
    private final String bodyHtml;
    private final GitHubUser assignee;
    private final List<GitHubLabel> labels;
    private final GitHubState state;
    private final GitHubMilestone milestone;
    private final LocalDateTime createdAt;
    private final LocalDateTime updatedAt;
    private final LocalDateTime closedAt;

    public String getKey() {
        return String.valueOf(this.id);
    }

    public String getDisplayKey() {
        return "#" + this.id;
    }

    public String getSummary() {
        return this.title;
    }

    public IssueStatus getStatus() {
        return new GitHubIssueStatus(this.state.name());
    }

    @JsonIgnore
    public LocalDateTime getUpdateTime() {
        return this.updatedAt;
    }

    @ConstructorProperties(value={"id", "url", "title", "body", "bodyHtml", "assignee", "labels", "state", "milestone", "createdAt", "updatedAt", "closedAt"})
    public GitHubIssue(int id, String url, String title, String body, String bodyHtml, GitHubUser assignee, List<GitHubLabel> labels, GitHubState state, GitHubMilestone milestone, LocalDateTime createdAt, LocalDateTime updatedAt, LocalDateTime closedAt) {
        this.id = id;
        this.url = url;
        this.title = title;
        this.body = body;
        this.bodyHtml = bodyHtml;
        this.assignee = assignee;
        this.labels = labels;
        this.state = state;
        this.milestone = milestone;
        this.createdAt = createdAt;
        this.updatedAt = updatedAt;
        this.closedAt = closedAt;
    }

    public int getId() {
        return this.id;
    }

    public String getUrl() {
        return this.url;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBody() {
        return this.body;
    }

    public String getBodyHtml() {
        return this.bodyHtml;
    }

    public GitHubUser getAssignee() {
        return this.assignee;
    }

    public List<GitHubLabel> getLabels() {
        return this.labels;
    }

    public GitHubState getState() {
        return this.state;
    }

    public GitHubMilestone getMilestone() {
        return this.milestone;
    }

    public LocalDateTime getCreatedAt() {
        return this.createdAt;
    }

    public LocalDateTime getUpdatedAt() {
        return this.updatedAt;
    }

    public LocalDateTime getClosedAt() {
        return this.closedAt;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitHubIssue)) {
            return false;
        }
        GitHubIssue other = (GitHubIssue)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getId() != other.getId()) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        if (this$body == null ? other$body != null : !this$body.equals(other$body)) {
            return false;
        }
        String this$bodyHtml = this.getBodyHtml();
        String other$bodyHtml = other.getBodyHtml();
        if (this$bodyHtml == null ? other$bodyHtml != null : !this$bodyHtml.equals(other$bodyHtml)) {
            return false;
        }
        GitHubUser this$assignee = this.getAssignee();
        GitHubUser other$assignee = other.getAssignee();
        if (this$assignee == null ? other$assignee != null : !((Object)this$assignee).equals(other$assignee)) {
            return false;
        }
        List<GitHubLabel> this$labels = this.getLabels();
        List<GitHubLabel> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        GitHubState this$state = this.getState();
        GitHubState other$state = other.getState();
        if (this$state == null ? other$state != null : !((Object)((Object)this$state)).equals((Object)other$state)) {
            return false;
        }
        GitHubMilestone this$milestone = this.getMilestone();
        GitHubMilestone other$milestone = other.getMilestone();
        if (this$milestone == null ? other$milestone != null : !((Object)this$milestone).equals(other$milestone)) {
            return false;
        }
        LocalDateTime this$createdAt = this.getCreatedAt();
        LocalDateTime other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        LocalDateTime this$updatedAt = this.getUpdatedAt();
        LocalDateTime other$updatedAt = other.getUpdatedAt();
        if (this$updatedAt == null ? other$updatedAt != null : !((Object)this$updatedAt).equals(other$updatedAt)) {
            return false;
        }
        LocalDateTime this$closedAt = this.getClosedAt();
        LocalDateTime other$closedAt = other.getClosedAt();
        return !(this$closedAt == null ? other$closedAt != null : !((Object)this$closedAt).equals(other$closedAt));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitHubIssue;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getId();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        String $bodyHtml = this.getBodyHtml();
        result = result * 59 + ($bodyHtml == null ? 43 : $bodyHtml.hashCode());
        GitHubUser $assignee = this.getAssignee();
        result = result * 59 + ($assignee == null ? 43 : ((Object)$assignee).hashCode());
        List<GitHubLabel> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        GitHubState $state = this.getState();
        result = result * 59 + ($state == null ? 43 : ((Object)((Object)$state)).hashCode());
        GitHubMilestone $milestone = this.getMilestone();
        result = result * 59 + ($milestone == null ? 43 : ((Object)$milestone).hashCode());
        LocalDateTime $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        LocalDateTime $updatedAt = this.getUpdatedAt();
        result = result * 59 + ($updatedAt == null ? 43 : ((Object)$updatedAt).hashCode());
        LocalDateTime $closedAt = this.getClosedAt();
        result = result * 59 + ($closedAt == null ? 43 : ((Object)$closedAt).hashCode());
        return result;
    }

    public String toString() {
        return "GitHubIssue(id=" + this.getId() + ", url=" + this.getUrl() + ", title=" + this.getTitle() + ", body=" + this.getBody() + ", bodyHtml=" + this.getBodyHtml() + ", assignee=" + this.getAssignee() + ", labels=" + this.getLabels() + ", state=" + (Object)((Object)this.getState()) + ", milestone=" + this.getMilestone() + ", createdAt=" + this.getCreatedAt() + ", updatedAt=" + this.getUpdatedAt() + ", closedAt=" + this.getClosedAt() + ")";
    }
}

