/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.ConstructorProperties;
import java.util.Optional;
import java.util.function.Function;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Password;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.support.ConfigurationDescriptor;
import net.nemerosa.ontrack.model.support.UserPassword;
import net.nemerosa.ontrack.model.support.UserPasswordConfiguration;
import org.apache.commons.lang3.StringUtils;

public class GitHubEngineConfiguration
implements UserPasswordConfiguration<GitHubEngineConfiguration> {
    public static final String GITHUB_COM = "https://github.com";
    private final String name;
    private final String url;
    private final String user;
    private final String password;
    private final String oauth2Token;

    @ConstructorProperties(value={"name", "url", "user", "password", "oauth2Token"})
    public GitHubEngineConfiguration(String name, String url, String user, String password, String oauth2Token) {
        this.name = name;
        this.url = StringUtils.isBlank((CharSequence)url) ? GITHUB_COM : url;
        this.user = user;
        this.password = password;
        this.oauth2Token = oauth2Token;
    }

    @JsonIgnore
    public ConfigurationDescriptor getDescriptor() {
        return new ConfigurationDescriptor(this.name, String.format("%s (%s)", this.name, this.url));
    }

    public GitHubEngineConfiguration obfuscate() {
        return this.withPassword("").withOauth2Token("");
    }

    public GitHubEngineConfiguration withPassword(String password) {
        return new GitHubEngineConfiguration(this.name, this.url, this.user, password, this.oauth2Token);
    }

    public static Form form() {
        return Form.create().with((Field)Form.defaultNameField()).with((Field)((Text)((Text)((Text)Text.of((String)"url").label("URL")).length(250)).optional()).help(String.format("URL of the GitHub engine. Defaults to %s if not defined.", GITHUB_COM))).with((Field)((Text)((Text)Text.of((String)"user").label("User")).length(16)).optional()).with((Field)((Password)((Password)Password.of((String)"password").label("Password")).length(40)).optional()).with((Field)((Text)((Text)Text.of((String)"oauth2Token").label("OAuth2 token")).length(50)).optional());
    }

    public Form asForm() {
        return GitHubEngineConfiguration.form().with((Field)((Text)Form.defaultNameField().readOnly()).value((Object)this.name)).fill("url", (Object)this.url).fill("user", (Object)this.user).fill("password", (Object)"").fill("oauth2Token", (Object)this.oauth2Token);
    }

    public GitHubEngineConfiguration clone(String targetConfigurationName, Function<String, String> replacementFunction) {
        return new GitHubEngineConfiguration(targetConfigurationName, replacementFunction.apply(this.url), replacementFunction.apply(this.user), this.password, this.oauth2Token);
    }

    @JsonIgnore
    public Optional<UserPassword> getCredentials() {
        if (StringUtils.isNotBlank((CharSequence)this.oauth2Token)) {
            return Optional.of(new UserPassword(this.oauth2Token, "x-oauth-basic"));
        }
        if (StringUtils.isNotBlank((CharSequence)this.user)) {
            return Optional.of(new UserPassword(this.user, this.password));
        }
        return Optional.empty();
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getOauth2Token() {
        return this.oauth2Token;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GitHubEngineConfiguration)) {
            return false;
        }
        GitHubEngineConfiguration other = (GitHubEngineConfiguration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$oauth2Token = this.getOauth2Token();
        String other$oauth2Token = other.getOauth2Token();
        return !(this$oauth2Token == null ? other$oauth2Token != null : !this$oauth2Token.equals(other$oauth2Token));
    }

    protected boolean canEqual(Object other) {
        return other instanceof GitHubEngineConfiguration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $oauth2Token = this.getOauth2Token();
        result = result * 59 + ($oauth2Token == null ? 43 : $oauth2Token.hashCode());
        return result;
    }

    public String toString() {
        return "GitHubEngineConfiguration(name=" + this.getName() + ", url=" + this.getUrl() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", oauth2Token=" + this.getOauth2Token() + ")";
    }

    public GitHubEngineConfiguration withOauth2Token(String oauth2Token) {
        return this.oauth2Token == oauth2Token ? this : new GitHubEngineConfiguration(this.name, this.url, this.user, this.password, oauth2Token);
    }
}

