/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github.client;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.common.Time;
import net.nemerosa.ontrack.extension.github.client.OntrackGitHubClient;
import net.nemerosa.ontrack.extension.github.client.OntrackGitHubClientException;
import net.nemerosa.ontrack.extension.github.model.GitHubEngineConfiguration;
import net.nemerosa.ontrack.extension.github.model.GitHubIssue;
import net.nemerosa.ontrack.extension.github.model.GitHubLabel;
import net.nemerosa.ontrack.extension.github.model.GitHubMilestone;
import net.nemerosa.ontrack.extension.github.model.GitHubState;
import net.nemerosa.ontrack.extension.github.model.GitHubUser;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.Label;
import org.eclipse.egit.github.core.Milestone;
import org.eclipse.egit.github.core.Repository;
import org.eclipse.egit.github.core.User;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.RequestException;
import org.eclipse.egit.github.core.service.IssueService;
import org.eclipse.egit.github.core.service.RepositoryService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultOntrackGitHubClient
implements OntrackGitHubClient {
    private final Logger logger = LoggerFactory.getLogger(OntrackGitHubClient.class);
    private final GitHubEngineConfiguration configuration;

    public DefaultOntrackGitHubClient(GitHubEngineConfiguration configuration) {
        this.configuration = configuration;
    }

    @Override
    public List<String> getRepositories() {
        this.logger.debug("[github] Getting repository list");
        GitHubClient client = this.createGitHubClient();
        RepositoryService repositoryService = new RepositoryService(client);
        try {
            return repositoryService.getRepositories().stream().map(Repository::getName).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new OntrackGitHubClientException(e);
        }
    }

    @Override
    public GitHubIssue getIssue(String repository, int id) {
        Issue issue;
        this.logger.debug("[github] Getting issue {}/{}", (Object)repository, (Object)id);
        GitHubClient client = this.createGitHubClient();
        IssueService service = new IssueService(client);
        String owner = StringUtils.substringBefore((String)repository, (String)"/");
        String name = StringUtils.substringAfter((String)repository, (String)"/");
        try {
            issue = service.getIssue(owner, name, id);
        }
        catch (RequestException ex) {
            if (ex.getStatus() == 404) {
                return null;
            }
            throw new OntrackGitHubClientException((IOException)((Object)ex));
        }
        catch (IOException e) {
            throw new OntrackGitHubClientException(e);
        }
        return new GitHubIssue(id, issue.getHtmlUrl(), issue.getTitle(), issue.getBodyText(), issue.getBodyHtml(), this.toUser(issue.getAssignee()), this.toLabels(issue.getLabels()), this.toState(issue.getState()), this.toMilestone(repository, issue.getMilestone()), this.toDateTime(issue.getCreatedAt()), this.toDateTime(issue.getUpdatedAt()), this.toDateTime(issue.getClosedAt()));
    }

    protected GitHubClient createGitHubClient() {
        GitHubClient client = new GitHubClient(){

            protected HttpURLConnection configureRequest(HttpURLConnection request) {
                HttpURLConnection connection = super.configureRequest(request);
                connection.setRequestProperty("Accept", "application/vnd.github.v3.full+json");
                return connection;
            }
        };
        String oAuth2Token = this.configuration.getOauth2Token();
        if (StringUtils.isNotBlank((CharSequence)oAuth2Token)) {
            client.setOAuth2Token(oAuth2Token);
        } else {
            String user = this.configuration.getUser();
            String password = this.configuration.getPassword();
            if (StringUtils.isNotBlank((CharSequence)user)) {
                client.setCredentials(user, password);
            }
        }
        return client;
    }

    private LocalDateTime toDateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Time.from((Date)date, null);
    }

    private GitHubMilestone toMilestone(String repository, Milestone milestone) {
        if (milestone != null) {
            return new GitHubMilestone(milestone.getTitle(), this.toState(milestone.getState()), milestone.getNumber(), String.format("%s/%s/issues?milestone=%d&state=open", this.configuration.getUrl(), repository, milestone.getNumber()));
        }
        return null;
    }

    private GitHubState toState(String state) {
        return GitHubState.valueOf(state);
    }

    private List<GitHubLabel> toLabels(List<Label> labels) {
        return labels.stream().map(label -> new GitHubLabel(label.getName(), label.getColor())).collect(Collectors.toList());
    }

    private GitHubUser toUser(User user) {
        if (user == null) {
            return null;
        }
        return new GitHubUser(user.getLogin(), user.getHtmlUrl());
    }
}

