/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.github.GitHubExtensionFeature;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationProperty;
import net.nemerosa.ontrack.extension.github.property.GitHubProjectConfigurationPropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitHubProjectDecorator
extends AbstractExtension
implements DecorationExtension<String> {
    private final PropertyService propertyService;

    @Autowired
    public GitHubProjectDecorator(GitHubExtensionFeature extensionFeature, PropertyService propertyService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
    }

    public List<Decoration<String>> getDecorations(ProjectEntity entity) {
        Property property = this.propertyService.getProperty(entity, GitHubProjectConfigurationPropertyType.class);
        if (!property.isEmpty()) {
            return Collections.singletonList(Decoration.of((Decorator)this, (Object)String.format("%s @ %s", ((GitHubProjectConfigurationProperty)property.getValue()).getRepository(), ((GitHubProjectConfigurationProperty)property.getValue()).getConfiguration().getName())));
        }
        return Collections.emptyList();
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }
}

