/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github;

import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.github.GitHubExtensionFeature;
import net.nemerosa.ontrack.extension.github.client.OntrackGitHubClient;
import net.nemerosa.ontrack.extension.github.client.OntrackGitHubClientFactory;
import net.nemerosa.ontrack.extension.github.model.GitHubEngineConfiguration;
import net.nemerosa.ontrack.extension.github.model.GitHubIssue;
import net.nemerosa.ontrack.extension.github.model.GitHubLabel;
import net.nemerosa.ontrack.extension.github.service.GitHubConfigurationService;
import net.nemerosa.ontrack.extension.github.service.GitHubIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.export.IssueExportServiceFactory;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.support.AbstractIssueServiceExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.support.MessageAnnotation;
import net.nemerosa.ontrack.model.support.MessageAnnotator;
import net.nemerosa.ontrack.model.support.RegexMessageAnnotator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GitHubIssueServiceExtension
extends AbstractIssueServiceExtension {
    public static final String GITHUB_SERVICE_ID = "github";
    public static final String GITHUB_ISSUE_PATTERN = "#(\\d+)";
    private final GitHubConfigurationService configurationService;
    private final OntrackGitHubClientFactory gitHubClientFactory;

    @Autowired
    public GitHubIssueServiceExtension(GitHubExtensionFeature extensionFeature, GitHubConfigurationService configurationService, OntrackGitHubClientFactory gitHubClientFactory, IssueExportServiceFactory issueExportServiceFactory) {
        super((ExtensionFeature)extensionFeature, GITHUB_SERVICE_ID, "GitHub", issueExportServiceFactory);
        this.configurationService = configurationService;
        this.gitHubClientFactory = gitHubClientFactory;
    }

    public List<? extends IssueServiceConfiguration> getConfigurationList() {
        return Collections.emptyList();
    }

    public IssueServiceConfiguration getConfigurationByName(String name) {
        String[] tokens = StringUtils.split((String)name, (String)":");
        if (tokens == null || tokens.length != 2) {
            throw new IllegalStateException("The GitHub issue configuration identifier name is expected using configuration:repository as a format");
        }
        String configuration = tokens[0];
        String repository = tokens[1];
        return new GitHubIssueServiceConfiguration((GitHubEngineConfiguration)this.configurationService.getConfiguration(configuration), repository);
    }

    public boolean validIssueToken(String token) {
        return Pattern.matches(GITHUB_ISSUE_PATTERN, token);
    }

    public Set<String> extractIssueKeysFromMessage(IssueServiceConfiguration issueServiceConfiguration, String message) {
        HashSet<String> result = new HashSet<String>();
        if (StringUtils.isNotBlank((CharSequence)message)) {
            Matcher matcher = Pattern.compile(GITHUB_ISSUE_PATTERN).matcher(message);
            while (matcher.find()) {
                String issueKey = matcher.group(1);
                result.add(issueKey);
            }
        }
        return result;
    }

    public Optional<MessageAnnotator> getMessageAnnotator(IssueServiceConfiguration issueServiceConfiguration) {
        GitHubIssueServiceConfiguration configuration = (GitHubIssueServiceConfiguration)issueServiceConfiguration;
        return Optional.of(new RegexMessageAnnotator(GITHUB_ISSUE_PATTERN, key -> MessageAnnotation.of((String)"a").attr("href", String.format("%s/%s/issues/%s", configuration.getConfiguration().getUrl(), configuration.getRepository(), key.substring(1))).text(key)));
    }

    public String getLinkForAllIssues(IssueServiceConfiguration issueServiceConfiguration, List<Issue> issues) {
        return null;
    }

    public Issue getIssue(IssueServiceConfiguration issueServiceConfiguration, String issueKey) {
        GitHubIssueServiceConfiguration configuration = (GitHubIssueServiceConfiguration)issueServiceConfiguration;
        OntrackGitHubClient client = this.gitHubClientFactory.create(configuration.getConfiguration());
        return client.getIssue(configuration.getRepository(), this.getIssueId(issueKey));
    }

    public Optional<String> getIssueId(IssueServiceConfiguration issueServiceConfiguration, String token) {
        if (StringUtils.isNumeric((CharSequence)token) || this.validIssueToken(token)) {
            return Optional.of(String.valueOf(this.getIssueId(token)));
        }
        return Optional.empty();
    }

    protected int getIssueId(String token) {
        return Integer.parseInt(StringUtils.stripStart((String)token, (String)"#"), 10);
    }

    public boolean containsIssueKey(IssueServiceConfiguration issueServiceConfiguration, String key, Set<String> keys) {
        if (StringUtils.isNumeric((CharSequence)key) || this.validIssueToken(key)) {
            Set ids = keys.stream().map(this::getIssueId).collect(Collectors.toSet());
            return ids.contains(this.getIssueId(key));
        }
        return false;
    }

    protected Set<String> getIssueTypes(IssueServiceConfiguration issueServiceConfiguration, Issue issue) {
        GitHubIssue gitHubIssue = (GitHubIssue)issue;
        return Sets.newLinkedHashSet((Iterable)gitHubIssue.getLabels().stream().map(GitHubLabel::getName).collect(Collectors.toList()));
    }
}

