/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.github;

import net.nemerosa.ontrack.extension.github.client.OntrackGitHubClient;
import net.nemerosa.ontrack.extension.github.client.OntrackGitHubClientFactory;
import net.nemerosa.ontrack.extension.github.model.GitHubEngineConfiguration;
import net.nemerosa.ontrack.extension.support.ConfigurationHealthIndicator;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.ConfigurationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.HealthAggregator;
import org.springframework.stereotype.Component;

@Component
public class GitHubHealthIndicator
extends ConfigurationHealthIndicator<GitHubEngineConfiguration> {
    private final OntrackGitHubClientFactory gitHubClientFactory;

    @Autowired
    public GitHubHealthIndicator(ConfigurationService<GitHubEngineConfiguration> configurationService, SecurityService securityService, HealthAggregator healthAggregator, OntrackGitHubClientFactory gitHubClientFactory) {
        super(configurationService, securityService, healthAggregator);
        this.gitHubClientFactory = gitHubClientFactory;
    }

    protected Health getHealth(GitHubEngineConfiguration config) {
        try {
            OntrackGitHubClient client = this.gitHubClientFactory.create(config);
            client.getRepositories();
            return Health.up().build();
        }
        catch (Exception ex) {
            return Health.down((Exception)ex).build();
        }
    }
}

