/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.ValidationStampWeatherDecoration;
import net.nemerosa.ontrack.extension.general.Weather;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ValidationStampWeatherDecorationExtension
extends AbstractExtension
implements DecorationExtension<ValidationStampWeatherDecoration> {
    private final StructureService structureService;

    @Autowired
    public ValidationStampWeatherDecorationExtension(GeneralExtensionFeature extensionFeature, StructureService structureService) {
        super((ExtensionFeature)extensionFeature);
        this.structureService = structureService;
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.of(ProjectEntityType.VALIDATION_STAMP);
    }

    public List<Decoration<ValidationStampWeatherDecoration>> getDecorations(ProjectEntity entity) {
        Validate.isTrue((boolean)(entity instanceof ValidationStamp), (String)"Expecting validation stamp", (Object[])new Object[0]);
        List runs = this.structureService.getValidationRunsForValidationStamp(entity.getId(), 0, 5);
        long notPassed = runs.stream().filter(run -> !run.isPassed()).count();
        ValidationStampWeatherDecoration decoration = notPassed == 0L ? new ValidationStampWeatherDecoration(Weather.sunny, "Sunny (0 failure in the last 5 builds)") : (notPassed == 1L ? new ValidationStampWeatherDecoration(Weather.sunAndClouds, "Sun and clouds (1 failure in the last 5 builds)") : (notPassed == 2L ? new ValidationStampWeatherDecoration(Weather.clouds, "Clouds (2 failures in the last 5 builds)") : (notPassed == 3L ? new ValidationStampWeatherDecoration(Weather.rain, "Rain (3 failures in the last 5 builds)") : new ValidationStampWeatherDecoration(Weather.storm, "Storm (4 failures or more in the last 5 builds)"))));
        return Collections.singletonList(Decoration.of((Decorator)this, (Object)decoration));
    }
}

