/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.ReleaseProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.PromotionRunCreate;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleasePropertyType
extends AbstractPropertyType<ReleaseProperty> {
    @Autowired
    public ReleasePropertyType(GeneralExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Release";
    }

    public String getDescription() {
        return "Release indicator on the build.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.BUILD);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, PromotionRunCreate.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, ReleaseProperty value) {
        return Form.create().with((Field)((Text)((Text)Text.of((String)"name").label("Release name")).length(20)).value((Object)(value != null ? value.getName() : null)));
    }

    public ReleaseProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public ReleaseProperty fromStorage(JsonNode node) {
        return new ReleaseProperty(node.path("name").asText());
    }

    public String getSearchKey(ReleaseProperty value) {
        return value.getName();
    }

    public ReleaseProperty replaceValue(ReleaseProperty value, Function<String, String> replacementFunction) {
        return value;
    }
}

