/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.ReleaseProperty;
import net.nemerosa.ontrack.extension.general.ReleasePropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.Property;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ReleaseDecorationExtension
extends AbstractExtension
implements DecorationExtension<String> {
    private final PropertyService propertyService;

    @Autowired
    public ReleaseDecorationExtension(GeneralExtensionFeature extensionFeature, PropertyService propertyService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.of(ProjectEntityType.BUILD);
    }

    public List<Decoration<String>> getDecorations(ProjectEntity entity) {
        Validate.isTrue((boolean)(entity instanceof Build), (String)"Expecting build", (Object[])new Object[0]);
        Property property = this.propertyService.getProperty(entity, ReleasePropertyType.class);
        if (property.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(Decoration.of((Decorator)this, (Object)((ReleaseProperty)property.getValue()).getName()));
    }
}

