/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.SearchExtension;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.MetaInfoProperty;
import net.nemerosa.ontrack.extension.general.MetaInfoPropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.SearchProvider;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.support.AbstractSearchProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetaInfoSearchExtension
extends AbstractExtension
implements SearchExtension {
    private final URIBuilder uriBuilder;
    private final PropertyService propertyService;
    private final StructureService structureService;

    @Autowired
    public MetaInfoSearchExtension(GeneralExtensionFeature extensionFeature, URIBuilder uriBuilder, PropertyService propertyService, StructureService structureService) {
        super((ExtensionFeature)extensionFeature);
        this.uriBuilder = uriBuilder;
        this.propertyService = propertyService;
        this.structureService = structureService;
    }

    public SearchProvider getSearchProvider() {
        return new AbstractSearchProvider(this.uriBuilder){

            public boolean isTokenSearchable(String token) {
                return MetaInfoSearchExtension.this.isTokenSearchable(token);
            }

            public Collection<SearchResult> search(String token) {
                return MetaInfoSearchExtension.this.search(token);
            }
        };
    }

    protected boolean isTokenSearchable(String token) {
        return StringUtils.indexOf((CharSequence)token, (CharSequence)":") > 0;
    }

    protected Collection<SearchResult> search(String token) {
        if (this.isTokenSearchable(token)) {
            String name = StringUtils.substringBefore((String)token, (String)":");
            String value = StringUtils.substringAfter((String)token, (String)":");
            Collection entities = this.propertyService.searchWithPropertyValue(MetaInfoPropertyType.class, (entityType, id) -> (ProjectEntity)entityType.getEntityFn(this.structureService).apply(id), metaInfoProperty -> metaInfoProperty.matchNameValue(name, value));
            return entities.stream().map(entity -> this.toSearchResult((ProjectEntity)entity, name)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected SearchResult toSearchResult(ProjectEntity entity, String name) {
        String value = ((MetaInfoProperty)this.propertyService.getProperty(entity, MetaInfoPropertyType.class).getValue()).getValue(name).orElseThrow(() -> new IllegalStateException("Expecting to have a meta info property"));
        return new SearchResult(entity.getEntityDisplayName(), String.format("%s -> %s", name, value), this.uriBuilder.getEntityURI(entity), this.uriBuilder.getEntityPage(entity), 100);
    }
}

