/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.MetaInfoProperty;
import net.nemerosa.ontrack.extension.general.MetaInfoPropertyItem;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiForm;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MetaInfoPropertyType
extends AbstractPropertyType<MetaInfoProperty> {
    @Autowired
    public MetaInfoPropertyType(GeneralExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Meta information";
    }

    public String getDescription() {
        return "List of meta information properties";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, MetaInfoProperty value) {
        return Form.create().with((Field)((MultiForm)MultiForm.of((String)"items", (Form)Form.create().name().with((Field)Text.of((String)"value").label("Value")).with((Field)((Text)Text.of((String)"link").label("Link")).optional()).with((Field)((Text)Text.of((String)"category").label("Category")).optional())).label("Items")).value(value != null ? value.getItems() : Collections.emptyList()));
    }

    public MetaInfoProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public MetaInfoProperty fromStorage(JsonNode node) {
        return (MetaInfoProperty)MetaInfoPropertyType.parse((JsonNode)node, MetaInfoProperty.class);
    }

    public String getSearchKey(MetaInfoProperty value) {
        return value.getItems().stream().map(item -> String.format("%s:%s", item.getName(), item.getValue())).collect(Collectors.joining(";"));
    }

    public boolean containsValue(MetaInfoProperty property, String propertyValue) {
        int pos = StringUtils.indexOf((CharSequence)propertyValue, (CharSequence)":");
        if (pos > 0) {
            String value = StringUtils.substringAfter((String)propertyValue, (String)":");
            String name = StringUtils.substringBefore((String)propertyValue, (String)":");
            return property.matchNameValue(name, value);
        }
        return false;
    }

    public MetaInfoProperty replaceValue(MetaInfoProperty value, Function<String, String> replacementFunction) {
        return new MetaInfoProperty(value.getItems().stream().map(item -> new MetaInfoPropertyItem(item.getName(), (String)replacementFunction.apply(item.getValue()), (String)replacementFunction.apply(item.getLink()), (String)replacementFunction.apply(item.getCategory()))).collect(Collectors.toList()));
    }
}

