/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.beans.ConstructorProperties;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class MetaInfoPropertyItem {
    private final String name;
    private final String value;
    private final String link;
    private final String category;

    public static MetaInfoPropertyItem of(String name, String value) {
        return new MetaInfoPropertyItem(name, value, null, null);
    }

    public boolean matchNameValue(String namePattern, String valuePattern) {
        return StringUtils.equals((CharSequence)this.name, (CharSequence)namePattern) && (StringUtils.isBlank((CharSequence)valuePattern) || StringUtils.equals((CharSequence)"*", (CharSequence)valuePattern) || Pattern.matches(StringUtils.replace((String)valuePattern, (String)"*", (String)".*"), this.value));
    }

    @ConstructorProperties(value={"name", "value", "link", "category"})
    public MetaInfoPropertyItem(String name, String value, String link, String category) {
        this.name = name;
        this.value = value;
        this.link = link;
        this.category = category;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public String getLink() {
        return this.link;
    }

    public String getCategory() {
        return this.category;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MetaInfoPropertyItem)) {
            return false;
        }
        MetaInfoPropertyItem other = (MetaInfoPropertyItem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$value = this.getValue();
        String other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        String this$link = this.getLink();
        String other$link = other.getLink();
        if (this$link == null ? other$link != null : !this$link.equals(other$link)) {
            return false;
        }
        String this$category = this.getCategory();
        String other$category = other.getCategory();
        return !(this$category == null ? other$category != null : !this$category.equals(other$category));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MetaInfoPropertyItem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        String $link = this.getLink();
        result = result * 59 + ($link == null ? 43 : $link.hashCode());
        String $category = this.getCategory();
        result = result * 59 + ($category == null ? 43 : $category.hashCode());
        return result;
    }

    public String toString() {
        return "MetaInfoPropertyItem(name=" + this.getName() + ", value=" + this.getValue() + ", link=" + this.getLink() + ", category=" + this.getCategory() + ")";
    }

    public MetaInfoPropertyItem withLink(String link) {
        return this.link == link ? this : new MetaInfoPropertyItem(this.name, this.value, link, this.category);
    }

    public MetaInfoPropertyItem withCategory(String category) {
        return this.category == category ? this : new MetaInfoPropertyItem(this.name, this.value, this.link, category);
    }
}

