/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.MessageProperty;
import net.nemerosa.ontrack.extension.general.MessageType;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.Memo;
import net.nemerosa.ontrack.model.form.Selection;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Describable;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessagePropertyType
extends AbstractPropertyType<MessageProperty> {
    @Autowired
    public MessagePropertyType(GeneralExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Message";
    }

    public String getDescription() {
        return "Message.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, MessageProperty value) {
        return Form.create().with((Field)((Selection)((Selection)Selection.of((String)"type").label("Type")).help("Type of message")).items(Arrays.asList(MessageType.values()).stream().map(Describable::toDescription).collect(Collectors.toList())).itemId("id").itemName("name").value((Object)(value != null ? value.getType().getId() : MessageType.INFO.getId()))).with((Field)((Memo)Memo.of((String)"text").label("Text")).value((Object)(value != null ? value.getText() : "")));
    }

    public MessageProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public MessageProperty fromStorage(JsonNode node) {
        return (MessageProperty)MessagePropertyType.parse((JsonNode)node, MessageProperty.class);
    }

    public String getSearchKey(MessageProperty value) {
        return value.getText();
    }

    public MessageProperty replaceValue(MessageProperty value, Function<String, String> replacementFunction) {
        return new MessageProperty(value.getType(), replacementFunction.apply(value.getText()));
    }
}

