/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.MessageProperty;
import net.nemerosa.ontrack.extension.general.MessagePropertyType;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PropertyService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class MessageDecorationExtension
extends AbstractExtension
implements DecorationExtension<MessageProperty> {
    private final PropertyService propertyService;

    @Autowired
    public MessageDecorationExtension(GeneralExtensionFeature extensionFeature, PropertyService propertyService) {
        super((ExtensionFeature)extensionFeature);
        this.propertyService = propertyService;
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public List<Decoration<MessageProperty>> getDecorations(ProjectEntity entity) {
        return this.propertyService.getProperty(entity, MessagePropertyType.class).option().map(messageProperty -> Collections.singletonList(Decoration.of((Decorator)this, (Object)messageProperty))).orElse(Collections.emptyList());
    }
}

