/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.general.LinkProperty;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.NamedEntries;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.support.NameValue;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LinkPropertyType
extends AbstractPropertyType<LinkProperty> {
    @Autowired
    public LinkPropertyType(GeneralExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public String getName() {
        return "Links";
    }

    public String getDescription() {
        return "List of links.";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.allOf(ProjectEntityType.class);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, LinkProperty value) {
        return Form.create().with((Field)((NamedEntries)((NamedEntries)NamedEntries.of((String)"links").label("List of links")).nameLabel("Name").valueLabel("Link").nameOptional().addText("Add a link").help("List of links associated with a name.")).value(value != null ? value.getLinks() : Collections.emptyList()));
    }

    public LinkProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public LinkProperty fromStorage(JsonNode node) {
        return (LinkProperty)LinkPropertyType.parse((JsonNode)node, LinkProperty.class);
    }

    public String getSearchKey(LinkProperty value) {
        return value.getLinks().stream().map(namedLink -> {
            if (StringUtils.isNotBlank((CharSequence)namedLink.getName())) {
                return namedLink.getName();
            }
            return namedLink.getValue();
        }).collect(Collectors.joining(","));
    }

    public LinkProperty replaceValue(LinkProperty value, Function<String, String> replacementFunction) {
        return new LinkProperty(value.getLinks().stream().map(nv -> new NameValue(nv.getName(), (String)replacementFunction.apply(nv.getValue()))).collect(Collectors.toList()));
    }
}

