/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.SearchExtension;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.SearchProvider;
import net.nemerosa.ontrack.model.structure.SearchResult;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.ui.controller.URIBuilder;
import net.nemerosa.ontrack.ui.support.AbstractSearchProvider;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BuildLinkSearchExtension
extends AbstractExtension
implements SearchExtension {
    private final URIBuilder uriBuilder;
    private final StructureService structureService;

    @Autowired
    public BuildLinkSearchExtension(GeneralExtensionFeature extensionFeature, URIBuilder uriBuilder, StructureService structureService) {
        super((ExtensionFeature)extensionFeature);
        this.uriBuilder = uriBuilder;
        this.structureService = structureService;
    }

    public SearchProvider getSearchProvider() {
        return new AbstractSearchProvider(this.uriBuilder){

            public boolean isTokenSearchable(String token) {
                return BuildLinkSearchExtension.this.isTokenSearchable(token);
            }

            public Collection<SearchResult> search(String token) {
                return BuildLinkSearchExtension.this.search(token);
            }
        };
    }

    protected boolean isTokenSearchable(String token) {
        return StringUtils.indexOf((CharSequence)token, (CharSequence)":") > 0;
    }

    protected Collection<SearchResult> search(String token) {
        if (this.isTokenSearchable(token)) {
            String project = StringUtils.substringBefore((String)token, (String)":");
            String buildName = StringUtils.substringAfter((String)token, (String)":");
            List builds = this.structureService.searchBuildsLinkedTo(project, buildName);
            return builds.stream().map(this::toSearchResult).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    protected SearchResult toSearchResult(Build build) {
        return new SearchResult(build.getEntityDisplayName(), String.format("%s -> %s", build.getProject().getName(), build.getName()), this.uriBuilder.getEntityURI((ProjectEntity)build), this.uriBuilder.getEntityPage((ProjectEntity)build), 100);
    }
}

