/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import net.nemerosa.ontrack.extension.api.DecorationExtension;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.BranchType;
import net.nemerosa.ontrack.model.structure.Decoration;
import net.nemerosa.ontrack.model.structure.Decorator;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BranchTemplateDecorator
extends AbstractExtension
implements DecorationExtension<BranchType> {
    @Autowired
    public BranchTemplateDecorator(GeneralExtensionFeature extensionFeature) {
        super((ExtensionFeature)extensionFeature);
    }

    public EnumSet<ProjectEntityType> getScope() {
        return EnumSet.of(ProjectEntityType.BRANCH);
    }

    public List<Decoration<BranchType>> getDecorations(ProjectEntity entity) {
        if (entity instanceof Branch) {
            Branch branch = (Branch)entity;
            switch (branch.getType()) {
                case TEMPLATE_DEFINITION: 
                case TEMPLATE_INSTANCE: {
                    return Collections.singletonList(Decoration.of((Decorator)this, (Object)branch.getType()));
                }
            }
            return Collections.emptyList();
        }
        return Collections.emptyList();
    }
}

