/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.general.AutoValidationStampProperty;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ValidationStampPropertyType;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.settings.PredefinedValidationStampService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.NameDescription;
import net.nemerosa.ontrack.model.structure.PredefinedValidationStamp;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoValidationStampPropertyType
extends AbstractPropertyType<AutoValidationStampProperty>
implements ValidationStampPropertyType<AutoValidationStampProperty> {
    private final PredefinedValidationStampService predefinedValidationStampService;
    private final SecurityService securityService;
    private final StructureService structureService;

    @Autowired
    public AutoValidationStampPropertyType(GeneralExtensionFeature extensionFeature, PredefinedValidationStampService predefinedValidationStampService, SecurityService securityService, StructureService structureService) {
        super((ExtensionFeature)extensionFeature);
        this.predefinedValidationStampService = predefinedValidationStampService;
        this.securityService = securityService;
        this.structureService = structureService;
    }

    public Optional<ValidationStamp> getOrCreateValidationStamp(AutoValidationStampProperty value, Branch branch, String validationStampName) {
        if (value.isAutoCreate()) {
            Optional oPredefinedValidationStamp = this.predefinedValidationStampService.findPredefinedValidationStampByName(validationStampName);
            if (oPredefinedValidationStamp.isPresent()) {
                return Optional.of(this.securityService.asAdmin(() -> this.structureService.newValidationStampFromPredefined(branch, (PredefinedValidationStamp)oPredefinedValidationStamp.get())));
            }
            if (value.isAutoCreateIfNotPredefined()) {
                return Optional.of(this.securityService.asAdmin(() -> this.structureService.newValidationStamp(ValidationStamp.of((Branch)branch, (NameDescription)NameDescription.nd((String)validationStampName, (String)"Validation automatically created on demand.")))));
            }
        }
        return Optional.empty();
    }

    public String getName() {
        return "Auto validation stamps";
    }

    public String getDescription() {
        return "If set, this property allows validation stamps to be created automatically from predefined validation stamps";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, AutoValidationStampProperty value) {
        return Form.create().with((Field)((YesNo)((YesNo)YesNo.of((String)"autoCreate").label("Auto creation")).help("If set, allows validation stamps to be created automatically")).value((Object)(value != null && value.isAutoCreate() ? 1 : 0))).with((Field)((YesNo)((YesNo)YesNo.of((String)"autoCreateIfNotPredefined").label("Auto creation if not predefined")).help("If set, allows validation stamps to be created automatically, even if not predefined version is present.")).value((Object)(value != null && value.isAutoCreateIfNotPredefined() ? 1 : 0)));
    }

    public AutoValidationStampProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public AutoValidationStampProperty fromStorage(JsonNode node) {
        return (AutoValidationStampProperty)AutoValidationStampPropertyType.parse((JsonNode)node, AutoValidationStampProperty.class);
    }

    public String getSearchKey(AutoValidationStampProperty value) {
        return "";
    }

    public AutoValidationStampProperty replaceValue(AutoValidationStampProperty value, Function<String, String> replacementFunction) {
        return value;
    }
}

