/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.common.MapBuilder;
import net.nemerosa.ontrack.extension.general.AutoPromotionProperty;
import net.nemerosa.ontrack.extension.general.AutoPromotionPropertyCannotParseException;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.json.JsonUtils;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.MultiSelection;
import net.nemerosa.ontrack.model.form.Text;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Entity;
import net.nemerosa.ontrack.model.structure.ID;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import net.nemerosa.ontrack.model.structure.ValidationStampSelection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoPromotionPropertyType
extends AbstractPropertyType<AutoPromotionProperty> {
    private final StructureService structureService;

    @Autowired
    public AutoPromotionPropertyType(GeneralExtensionFeature extensionFeature, StructureService structureService) {
        super((ExtensionFeature)extensionFeature);
        this.structureService = structureService;
    }

    public String getName() {
        return "Auto promotion";
    }

    public String getDescription() {
        return "Allows a promotion level to be granted on a build as soon as a list of validation stamps has been passed";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROMOTION_LEVEL);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, AutoPromotionProperty value) {
        PromotionLevel promotionLevel = (PromotionLevel)entity;
        return Form.create().with((Field)((MultiSelection)MultiSelection.of((String)"validationStamps").label("Validation stamps")).items(this.structureService.getValidationStampListForBranch(promotionLevel.getBranch().getId()).stream().map(vs -> new ValidationStampSelection(vs, value != null && value.containsDirectValidationStamp((ValidationStamp)vs))).collect(Collectors.toList())).help("When all the selected validation stamps have passed for a build, the promotion will automatically be granted.")).with((Field)((Text)((Text)((Text)Text.of((String)"include").label("Include")).optional()).value((Object)(value != null ? value.getInclude() : ""))).help("Regular expression to select validation stamps by name")).with((Field)((Text)((Text)((Text)Text.of((String)"exclude").label("Exclude")).optional()).value((Object)(value != null ? value.getExclude() : ""))).help("Regular expression to exclude validation stamps by name"));
    }

    public AutoPromotionProperty fromClient(JsonNode node) {
        return this.loadAutoPromotionProperty(node);
    }

    private AutoPromotionProperty loadAutoPromotionProperty(JsonNode node) {
        if (node.isArray()) {
            return new AutoPromotionProperty(this.readValidationStamps(node), "", "");
        }
        JsonNode validationStamps = node.get("validationStamps");
        List<ValidationStamp> validationStampList = this.readValidationStamps(validationStamps);
        return new AutoPromotionProperty(validationStampList, JsonUtils.get((JsonNode)node, (String)"include", (boolean)false, (String)""), JsonUtils.get((JsonNode)node, (String)"exclude", (boolean)false, (String)""));
    }

    private List<ValidationStamp> readValidationStamps(JsonNode validationStampIds) {
        if (!validationStampIds.isArray()) {
            throw new AutoPromotionPropertyCannotParseException("Cannot get the list of validation stamps");
        }
        ArrayList ids = new ArrayList();
        validationStampIds.forEach(id -> ids.add(id.asInt()));
        List<ValidationStamp> validationStampList = ids.stream().map(id -> this.structureService.getValidationStamp(ID.of((int)id))).collect(Collectors.toList());
        return validationStampList;
    }

    public AutoPromotionProperty copy(ProjectEntity sourceEntity, AutoPromotionProperty value, ProjectEntity targetEntity, Function<String, String> replacementFn) {
        PromotionLevel targetPromotionLevel = (PromotionLevel)targetEntity;
        return new AutoPromotionProperty(value.getValidationStamps().stream().map(vs -> this.structureService.findValidationStampByName(targetPromotionLevel.getBranch().getProject().getName(), targetPromotionLevel.getBranch().getName(), vs.getName())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList()), value.getInclude(), value.getExclude());
    }

    public JsonNode forStorage(AutoPromotionProperty value) {
        return AutoPromotionPropertyType.format((Object)MapBuilder.create().with((Object)"validationStamps", value.getValidationStamps().stream().map(Entity::id).collect(Collectors.toList())).with((Object)"include", (Object)value.getInclude()).with((Object)"exclude", (Object)value.getExclude()).get());
    }

    public AutoPromotionProperty fromStorage(JsonNode node) {
        return this.loadAutoPromotionProperty(node);
    }

    public String getSearchKey(AutoPromotionProperty value) {
        return "";
    }

    public AutoPromotionProperty replaceValue(AutoPromotionProperty value, Function<String, String> replacementFunction) {
        return value;
    }
}

