/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.beans.ConstructorProperties;
import java.util.List;
import java.util.regex.Pattern;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import org.apache.commons.lang3.StringUtils;

public class AutoPromotionProperty {
    private final List<ValidationStamp> validationStamps;
    private final String include;
    private final String exclude;

    public boolean contains(ValidationStamp vs) {
        return this.containsDirectValidationStamp(vs) || this.containsByPattern(vs);
    }

    public boolean containsDirectValidationStamp(ValidationStamp vs) {
        return this.validationStamps.stream().anyMatch(v -> v.id() == vs.id());
    }

    private boolean containsByPattern(ValidationStamp vs) {
        return this.includes(vs) && !this.excludes(vs);
    }

    private boolean includes(ValidationStamp vs) {
        return this.matches(vs, this.include);
    }

    private boolean excludes(ValidationStamp vs) {
        return this.matches(vs, this.exclude);
    }

    private boolean matches(ValidationStamp vs, String pattern) {
        return StringUtils.isNotBlank((CharSequence)pattern) && Pattern.matches(pattern, vs.getName());
    }

    @ConstructorProperties(value={"validationStamps", "include", "exclude"})
    public AutoPromotionProperty(List<ValidationStamp> validationStamps, String include, String exclude) {
        this.validationStamps = validationStamps;
        this.include = include;
        this.exclude = exclude;
    }

    public List<ValidationStamp> getValidationStamps() {
        return this.validationStamps;
    }

    public String getInclude() {
        return this.include;
    }

    public String getExclude() {
        return this.exclude;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutoPromotionProperty)) {
            return false;
        }
        AutoPromotionProperty other = (AutoPromotionProperty)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ValidationStamp> this$validationStamps = this.getValidationStamps();
        List<ValidationStamp> other$validationStamps = other.getValidationStamps();
        if (this$validationStamps == null ? other$validationStamps != null : !((Object)this$validationStamps).equals(other$validationStamps)) {
            return false;
        }
        String this$include = this.getInclude();
        String other$include = other.getInclude();
        if (this$include == null ? other$include != null : !this$include.equals(other$include)) {
            return false;
        }
        String this$exclude = this.getExclude();
        String other$exclude = other.getExclude();
        return !(this$exclude == null ? other$exclude != null : !this$exclude.equals(other$exclude));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutoPromotionProperty;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ValidationStamp> $validationStamps = this.getValidationStamps();
        result = result * 59 + ($validationStamps == null ? 43 : ((Object)$validationStamps).hashCode());
        String $include = this.getInclude();
        result = result * 59 + ($include == null ? 43 : $include.hashCode());
        String $exclude = this.getExclude();
        result = result * 59 + ($exclude == null ? 43 : $exclude.hashCode());
        return result;
    }

    public String toString() {
        return "AutoPromotionProperty(validationStamps=" + this.getValidationStamps() + ", include=" + this.getInclude() + ", exclude=" + this.getExclude() + ")";
    }
}

