/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.nemerosa.ontrack.extension.general.AutoPromotionLevelProperty;
import net.nemerosa.ontrack.extension.general.GeneralExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractPropertyType;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.PromotionLevelPropertyType;
import net.nemerosa.ontrack.model.form.Field;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.form.YesNo;
import net.nemerosa.ontrack.model.security.ProjectConfig;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.settings.PredefinedPromotionLevelService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.PredefinedPromotionLevel;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.StructureService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoPromotionLevelPropertyType
extends AbstractPropertyType<AutoPromotionLevelProperty>
implements PromotionLevelPropertyType<AutoPromotionLevelProperty> {
    private final PredefinedPromotionLevelService predefinedPromotionLevelService;
    private final StructureService structureService;
    private final SecurityService securityService;

    @Autowired
    public AutoPromotionLevelPropertyType(GeneralExtensionFeature extensionFeature, PredefinedPromotionLevelService predefinedPromotionLevelService, StructureService structureService, SecurityService securityService) {
        super((ExtensionFeature)extensionFeature);
        this.predefinedPromotionLevelService = predefinedPromotionLevelService;
        this.structureService = structureService;
        this.securityService = securityService;
    }

    public Optional<PromotionLevel> getOrCreatePromotionLevel(AutoPromotionLevelProperty value, Branch branch, String promotionLevelName) {
        Optional oPredefinedPromotionLevel;
        if (value.isAutoCreate() && (oPredefinedPromotionLevel = this.predefinedPromotionLevelService.findPredefinedPromotionLevelByName(promotionLevelName)).isPresent()) {
            return Optional.of(this.securityService.asAdmin(() -> this.structureService.newPromotionLevelFromPredefined(branch, (PredefinedPromotionLevel)oPredefinedPromotionLevel.get())));
        }
        return Optional.empty();
    }

    public String getName() {
        return "Auto promotion levels";
    }

    public String getDescription() {
        return "If set, this property allows promotion levels to be created automatically from predefined promotion levels";
    }

    public Set<ProjectEntityType> getSupportedEntityTypes() {
        return EnumSet.of(ProjectEntityType.PROJECT);
    }

    public boolean canEdit(ProjectEntity entity, SecurityService securityService) {
        return securityService.isProjectFunctionGranted(entity, ProjectConfig.class);
    }

    public boolean canView(ProjectEntity entity, SecurityService securityService) {
        return true;
    }

    public Form getEditionForm(ProjectEntity entity, AutoPromotionLevelProperty value) {
        return Form.create().with((Field)((YesNo)((YesNo)YesNo.of((String)"autoCreate").label("Auto creation")).help("If set, allows promotion levels to be created automatically")).value((Object)(value != null && value.isAutoCreate() ? 1 : 0)));
    }

    public AutoPromotionLevelProperty fromClient(JsonNode node) {
        return this.fromStorage(node);
    }

    public AutoPromotionLevelProperty fromStorage(JsonNode node) {
        return (AutoPromotionLevelProperty)AutoPromotionLevelPropertyType.parse((JsonNode)node, AutoPromotionLevelProperty.class);
    }

    public String getSearchKey(AutoPromotionLevelProperty value) {
        return "";
    }

    public AutoPromotionLevelProperty replaceValue(AutoPromotionLevelProperty value, Function<String, String> replacementFunction) {
        return value;
    }
}

