/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.general;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.general.AutoPromotionProperty;
import net.nemerosa.ontrack.extension.general.AutoPromotionPropertyType;
import net.nemerosa.ontrack.model.events.Event;
import net.nemerosa.ontrack.model.events.EventFactory;
import net.nemerosa.ontrack.model.events.EventListener;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.structure.Branch;
import net.nemerosa.ontrack.model.structure.Build;
import net.nemerosa.ontrack.model.structure.ProjectEntity;
import net.nemerosa.ontrack.model.structure.ProjectEntityType;
import net.nemerosa.ontrack.model.structure.PromotionLevel;
import net.nemerosa.ontrack.model.structure.PromotionRun;
import net.nemerosa.ontrack.model.structure.PropertyService;
import net.nemerosa.ontrack.model.structure.Signature;
import net.nemerosa.ontrack.model.structure.StructureService;
import net.nemerosa.ontrack.model.structure.ValidationRun;
import net.nemerosa.ontrack.model.structure.ValidationRunStatusID;
import net.nemerosa.ontrack.model.structure.ValidationStamp;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AutoPromotionEventListener
implements EventListener {
    private final StructureService structureService;
    private final PropertyService propertyService;
    private final SecurityService securityService;

    @Autowired
    public AutoPromotionEventListener(StructureService structureService, PropertyService propertyService, SecurityService securityService) {
        this.structureService = structureService;
        this.propertyService = propertyService;
        this.securityService = securityService;
    }

    public void onEvent(Event event) {
        if (event.getEventType() == EventFactory.NEW_VALIDATION_RUN) {
            this.onNewValidationRun(event);
        } else if (event.getEventType() == EventFactory.DELETE_VALIDATION_STAMP) {
            this.onDeleteValidationStamp(event);
        }
    }

    private void onDeleteValidationStamp(Event event) {
        int validationStampId = event.getIntValue("validation_stamp_id");
        Branch branch = (Branch)event.getEntity(ProjectEntityType.BRANCH);
        List promotionLevels = this.structureService.getPromotionLevelListForBranch(branch.getId());
        promotionLevels.forEach(promotionLevel -> this.cleanPromotionLevel((PromotionLevel)promotionLevel, validationStampId));
    }

    private void cleanPromotionLevel(PromotionLevel promotionLevel, int validationStampId) {
        AutoPromotionProperty property;
        List<ValidationStamp> keptValidationStamps;
        Optional oProperty = this.propertyService.getProperty((ProjectEntity)promotionLevel, AutoPromotionPropertyType.class).option();
        if (oProperty.isPresent() && (keptValidationStamps = (property = (AutoPromotionProperty)oProperty.get()).getValidationStamps().stream().filter(validationStamp -> validationStampId != validationStamp.id()).collect(Collectors.toList())).size() < property.getValidationStamps().size()) {
            property = new AutoPromotionProperty(keptValidationStamps, property.getInclude(), property.getExclude());
            this.propertyService.editProperty((ProjectEntity)promotionLevel, AutoPromotionPropertyType.class, (Object)property);
        }
    }

    private void onNewValidationRun(Event event) {
        ValidationRun validationRun = (ValidationRun)event.getEntity(ProjectEntityType.VALIDATION_RUN);
        if (Objects.equals(validationRun.getLastStatus().getStatusID(), ValidationRunStatusID.STATUS_PASSED)) {
            Branch branch = (Branch)event.getEntity(ProjectEntityType.BRANCH);
            Build build = (Build)event.getEntity(ProjectEntityType.BUILD);
            List promotionLevels = this.structureService.getPromotionLevelListForBranch(branch.getId());
            List validationStamps = this.structureService.getValidationStampListForBranch(branch.getId());
            promotionLevels.forEach(promotionLevel -> this.checkPromotionLevel(build, (PromotionLevel)promotionLevel, validationStamps));
        }
    }

    protected void checkPromotionLevel(Build build, PromotionLevel promotionLevel, List<ValidationStamp> validationStamps) {
        Optional oProperty = this.propertyService.getProperty((ProjectEntity)promotionLevel, AutoPromotionPropertyType.class).option();
        if (oProperty.isPresent()) {
            AutoPromotionProperty property = (AutoPromotionProperty)oProperty.get();
            List runs = this.structureService.getPromotionRunsForBuildAndPromotionLevel(build, promotionLevel);
            if (runs.isEmpty()) {
                boolean allPassed = validationStamps.stream().filter(property::contains).allMatch(validationStamp -> this.isPassed(build, (ValidationStamp)validationStamp));
                if (allPassed) {
                    this.structureService.newPromotionRun(PromotionRun.of((Build)build, (PromotionLevel)promotionLevel, (Signature)this.securityService.getCurrentSignature(), (String)"Auto promotion"));
                }
            }
        }
    }

    protected boolean isPassed(Build build, ValidationStamp validationStamp) {
        List runs = this.structureService.getValidationRunsForBuildAndValidationStamp(build.getId(), validationStamp.getId());
        if (runs.isEmpty()) {
            return false;
        }
        ValidationRun run = (ValidationRun)runs.get(0);
        return Objects.equals(run.getLastStatus().getStatusID(), ValidationRunStatusID.STATUS_PASSED);
    }
}

