angular.module("ontrack.extension.combined",["ui.router","ot.service.core","ot.service.form"]).config(["$stateProvider",function(e){e.state("combined-issue-service-configurations",{url:"/extension/combined/configurations",templateUrl:"extension/combined/combined.configurations.tpl.html",controller:"CombinedConfigurationsCtrl"})}]).controller("CombinedConfigurationsCtrl",["$scope","$http","ot","otFormService","otAlertService",function(e,i,t,n,o){function r(){t.call(i.get("extension/issue/combined/configurations")).then(function(i){e.configurations=i,c.commands=[{id:"configuration-create",name:"Create a configuration",cls:"ot-command-new",action:e.createConfiguration},t.viewApiCommand(i._self),t.viewCloseCommand("/home")]})}var c=t.view();c.title="Combined issue services configurations",c.description="Management of the combined issue services configurations.",r(),e.createConfiguration=function(){n.display({uri:e.configurations._create,title:"JIRA configuration",submit:function(n){return t.call(i.post(e.configurations._create,n))}}).then(r)},e.deleteConfiguration=function(e){o.confirm({title:"Deleting configuration",message:"Do you really want to delete this JIRA configuration? Some projects may still refer to it."}).then(function(){t.call(i["delete"](e._delete)).then(r)})},e.updateConfiguration=function(e){n.display({uri:e._update,title:"JIRA configuration",submit:function(n){return t.call(i.put(e._update,n))}}).then(r)}}]).directive("otExtensionJiraIssueLink",function(){return{restrict:"E",templateUrl:"extension/jira/directive.jiraIssueLink.tpl.html",scope:{issue:"="}}});
angular.module("ontrack-extension-combined-templates",[]).run(["$log","$templateCache",function(n,t){n.info("Loading templates for combined @ master-b3d7f65"),t.put("extension/combined/changelog.issues.tpl.html",'<table class="table table-hover table-condensed">\n    <thead>\n    <tr>\n        <th>Key</th>\n        <th>Status</th>\n        <th>Summary</th>\n        <th>Updated</th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr ng-repeat="changeLogIssue in value.list">\n        <td>\n            <span ng-if="changeLogIssue.issue.url"><a href="{{changeLogIssue.issue.url}}">{{changeLogIssue.issue.displayKey}}</a></span>\n            <span ng-if="!changeLogIssue.issue.url">{{changeLogIssue.issue.displayKey}}</span>\n        </td>\n        <td>\n            {{changeLogIssue.issue.status.name}}\n        </td>\n        <td>\n            {{changeLogIssue.issue.summary}}\n        </td>\n        <td>\n            {{changeLogIssue.issue.updateTime | date: \'mediumDate\'}}\n        </td>\n    </tr>\n    </tbody>\n</table>'),t.put("extension/combined/combined.configurations.tpl.html",'<ot-view>\n    <div class="row">\n        <div class="col-md-12">\n            <ot-section-title>List of configurations</ot-section-title>\n            <ot-noentry list="configurations.resources">\n                No configuration has been created yet.\n            </ot-noentry>\n            <table class="table table-hover">\n                <tr ng-repeat="configuration in configurations.resources">\n                    <td>\n                        <code>{{configuration.name}}</code>\n                    </td>\n                    <td>\n                        <span ng-repeat="identifier in configuration.issueServiceConfigurationIdentifiers" class="ot-property-label">\n                            {{identifier}}\n                        </span>\n                    </td>\n                    <td>\n                        <span class="ot-command" ng-click="updateConfiguration(configuration)">\n                            <span class="ot-command-update"></span>\n                            Update\n                        </span>\n                        <span class="ot-command" ng-click="deleteConfiguration(configuration)">\n                            <span class="ot-command-delete"></span>\n                            Delete\n                        </span>\n                    </td>\n                </tr>\n            </table>\n        </div>\n    </div>\n</ot-view>'),t.put("extension/combined/issue.tpl.html",'<table>\n    <tbody>\n    <tr>\n        <td>\n            Key:\n        </td>\n        <td>\n            <span ng-if="value.url"><a href="{{value.url}}">{{value.displayKey}}</a></span>\n            <span ng-if="!value.url">{{value.displayKey}}</span>\n        </td>\n    </tr>\n    <tr>\n        <td>\n            Status:\n        </td>\n        <td>\n            {{value.status.name}}\n        </td>\n    </tr>\n    <tr>\n        <td>\n            Summary:\n        </td>\n        <td>\n            {{value.summary}}\n        </td>\n    </tr>\n    <tr>\n        <td>\n            Update time\n        </td>\n        <td>\n            {{value.updateTime | date: \'mediumDate\'}}\n        </td>\n    </tr>\n    </tbody>\n</table>')}]);