/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.combined;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.api.model.IssueChangeLogExportRequest;
import net.nemerosa.ontrack.extension.issues.IssueServiceExtension;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceConfigurationService;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceExtensionFeature;
import net.nemerosa.ontrack.extension.issues.export.ExportFormat;
import net.nemerosa.ontrack.extension.issues.export.ExportedIssues;
import net.nemerosa.ontrack.extension.issues.model.ConfiguredIssueService;
import net.nemerosa.ontrack.extension.issues.model.Issue;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfiguration;
import net.nemerosa.ontrack.extension.support.AbstractExtension;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.support.MessageAnnotator;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CombinedIssueServiceExtension
extends AbstractExtension
implements IssueServiceExtension {
    public static final String SERVICE = "combined";
    private final CombinedIssueServiceConfigurationService configurationService;
    private final IssueServiceRegistry issueServiceRegistry;

    @Autowired
    public CombinedIssueServiceExtension(CombinedIssueServiceExtensionFeature extensionFeature, IssueServiceRegistry issueServiceRegistry, CombinedIssueServiceConfigurationService configurationService) {
        super((ExtensionFeature)extensionFeature);
        this.issueServiceRegistry = issueServiceRegistry;
        this.configurationService = configurationService;
    }

    protected Collection<ConfiguredIssueService> getConfiguredIssueServices(IssueServiceConfiguration issueServiceConfiguration) {
        CombinedIssueServiceConfiguration combinedIssueServiceConfiguration = (CombinedIssueServiceConfiguration)issueServiceConfiguration;
        return combinedIssueServiceConfiguration.getIssueServiceConfigurationIdentifiers().stream().map(arg_0 -> ((IssueServiceRegistry)this.issueServiceRegistry).getConfiguredIssueService(arg_0)).collect(Collectors.toList());
    }

    public String getId() {
        return SERVICE;
    }

    public String getName() {
        return "Combined issue service";
    }

    public List<? extends IssueServiceConfiguration> getConfigurationList() {
        return this.configurationService.getConfigurationList();
    }

    public IssueServiceConfiguration getConfigurationByName(String name) {
        return this.configurationService.getConfigurationByName(name).orElse(null);
    }

    public boolean validIssueToken(String token) {
        return true;
    }

    public Set<String> extractIssueKeysFromMessage(IssueServiceConfiguration issueServiceConfiguration, String message) {
        return this.getConfiguredIssueServices(issueServiceConfiguration).stream().map(configuredIssueService -> configuredIssueService.getIssueServiceExtension().extractIssueKeysFromMessage(configuredIssueService.getIssueServiceConfiguration(), message)).collect(Collectors.reducing(Collections.emptySet(), Sets::union));
    }

    public Optional<MessageAnnotator> getMessageAnnotator(IssueServiceConfiguration issueServiceConfiguration) {
        Collection messageAnnotators = this.getConfiguredIssueServices(issueServiceConfiguration).stream().map(configuredIssueService -> configuredIssueService.getIssueServiceExtension().getMessageAnnotator(configuredIssueService.getIssueServiceConfiguration())).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (messageAnnotators.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(text -> messageAnnotators.stream().map(messageAnnotator -> messageAnnotator.annotate(text)).map(HashSet::new).collect(Collectors.reducing(Collections.emptySet(), Sets::union)));
    }

    public String getLinkForAllIssues(IssueServiceConfiguration issueServiceConfiguration, List<Issue> issues) {
        return null;
    }

    public Issue getIssue(IssueServiceConfiguration issueServiceConfiguration, String issueKey) {
        return this.getConfiguredIssueServices(issueServiceConfiguration).stream().map(configuredIssueService -> configuredIssueService.getIssueServiceExtension().getIssue(configuredIssueService.getIssueServiceConfiguration(), issueKey)).filter(issue -> issue != null).findFirst().orElse(null);
    }

    public boolean containsIssueKey(IssueServiceConfiguration issueServiceConfiguration, String key, Set<String> keys) {
        return this.getConfiguredIssueServices(issueServiceConfiguration).stream().anyMatch(configuredIssueService -> configuredIssueService.getIssueServiceExtension().containsIssueKey(configuredIssueService.getIssueServiceConfiguration(), key, keys));
    }

    public List<ExportFormat> exportFormats(IssueServiceConfiguration issueServiceConfiguration) {
        Set lists = this.getConfiguredIssueServices(issueServiceConfiguration).stream().map(configuredIssueService -> configuredIssueService.getIssueServiceExtension().exportFormats(configuredIssueService.getIssueServiceConfiguration())).map(HashSet::new).collect(Collectors.reducing(Collections.emptySet(), Sets::union));
        return new ArrayList<ExportFormat>(lists);
    }

    public ExportedIssues exportIssues(IssueServiceConfiguration issueServiceConfiguration, List<? extends Issue> issues, IssueChangeLogExportRequest request) {
        List exportedIssues = this.getConfiguredIssueServices(issueServiceConfiguration).stream().map(configuredIssueService -> configuredIssueService.getIssueServiceExtension().exportIssues(configuredIssueService.getIssueServiceConfiguration(), issues, request)).collect(Collectors.toList());
        if (!exportedIssues.stream().allMatch(it -> StringUtils.equals((CharSequence)it.getFormat(), (CharSequence)request.getFormat()))) {
            throw new IllegalStateException("All exported issues must have the same export format");
        }
        return new ExportedIssues(request.getFormat(), exportedIssues.stream().map(ExportedIssues::getContent).collect(Collectors.joining("")));
    }

    public Optional<String> getIssueId(IssueServiceConfiguration issueServiceConfiguration, String token) {
        return this.getConfiguredIssueServices(issueServiceConfiguration).stream().map(configuredIssueService -> configuredIssueService.getIssueServiceExtension().getIssueId(configuredIssueService.getIssueServiceConfiguration(), token)).filter(Optional::isPresent).findFirst().orElse(Optional.empty());
    }
}

