/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.combined;

import java.net.URI;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceConfigurationService;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceExtensionFeature;
import net.nemerosa.ontrack.extension.support.AbstractExtensionController;
import net.nemerosa.ontrack.model.Ack;
import net.nemerosa.ontrack.model.extension.ExtensionFeature;
import net.nemerosa.ontrack.model.extension.ExtensionFeatureDescription;
import net.nemerosa.ontrack.model.form.Form;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.ui.resource.Resource;
import net.nemerosa.ontrack.ui.resource.Resources;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.mvc.method.annotation.MvcUriComponentsBuilder;

@RequestMapping(value={"extension/issue/combined"})
@RestController
public class CombinedIssueServiceController
extends AbstractExtensionController<CombinedIssueServiceExtensionFeature> {
    private final CombinedIssueServiceConfigurationService configurationService;
    private final SecurityService securityService;

    @Autowired
    public CombinedIssueServiceController(CombinedIssueServiceExtensionFeature extensionFeature, CombinedIssueServiceConfigurationService configurationService, SecurityService securityService) {
        super((ExtensionFeature)extensionFeature);
        this.configurationService = configurationService;
        this.securityService = securityService;
    }

    @RequestMapping(value={""}, method={RequestMethod.GET})
    public Resource<ExtensionFeatureDescription> getDescription() {
        return (Resource)Resource.of((Object)((CombinedIssueServiceExtensionFeature)this.feature).getFeatureDescription(), (URI)this.uri(((CombinedIssueServiceController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getDescription())).with("configurations", this.uri(((CombinedIssueServiceController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationList()), this.securityService.isGlobalFunctionGranted(GlobalSettings.class));
    }

    @RequestMapping(value={"configurations"}, method={RequestMethod.GET})
    public Resources<CombinedIssueServiceConfiguration> getConfigurationList() {
        return (Resources)Resources.of(this.configurationService.getConfigurationList(), (URI)this.uri(((CombinedIssueServiceController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationList())).with("_create", this.uri(((CombinedIssueServiceController)((Object)MvcUriComponentsBuilder.on(((Object)((Object)this)).getClass()))).getConfigurationForm()));
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.GET})
    public Form getConfigurationForm() {
        return CombinedIssueServiceConfiguration.form(this.configurationService.getAvailableIssueServiceConfigurations());
    }

    @RequestMapping(value={"configurations/create"}, method={RequestMethod.POST})
    public CombinedIssueServiceConfiguration newConfiguration(@RequestBody CombinedIssueServiceConfiguration configuration) {
        return this.configurationService.newConfiguration(configuration);
    }

    @RequestMapping(value={"configurations/{name}"}, method={RequestMethod.GET})
    public CombinedIssueServiceConfiguration getConfiguration(@PathVariable String name) {
        return this.configurationService.getConfiguration(name);
    }

    @RequestMapping(value={"configurations/{name}/update"}, method={RequestMethod.GET})
    public Form updateConfigurationForm(@PathVariable String name) {
        return this.configurationService.getConfiguration(name).asForm(this.configurationService.getAvailableIssueServiceConfigurations());
    }

    @RequestMapping(value={"configurations/{name}/update"}, method={RequestMethod.PUT})
    public CombinedIssueServiceConfiguration updateConfiguration(@PathVariable String name, @RequestBody CombinedIssueServiceConfiguration configuration) {
        this.configurationService.updateConfiguration(name, configuration);
        return this.getConfiguration(name);
    }

    @RequestMapping(value={"configurations/{name}"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public Ack deleteConfiguration(@PathVariable String name) {
        this.configurationService.deleteConfiguration(name);
        return Ack.OK;
    }
}

