/*
 * Decompiled with CFR 0.152.
 */
package net.nemerosa.ontrack.extension.issues.combined;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.nemerosa.ontrack.extension.issues.IssueServiceRegistry;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceConfiguration;
import net.nemerosa.ontrack.extension.issues.combined.CombinedIssueServiceConfigurationService;
import net.nemerosa.ontrack.extension.issues.model.IssueServiceConfigurationRepresentation;
import net.nemerosa.ontrack.model.security.GlobalSettings;
import net.nemerosa.ontrack.model.security.SecurityService;
import net.nemerosa.ontrack.model.support.Configuration;
import net.nemerosa.ontrack.model.support.ConfigurationNotFoundException;
import net.nemerosa.ontrack.model.support.ConfigurationRepository;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class CombinedIssueServiceConfigurationServiceImpl
implements CombinedIssueServiceConfigurationService {
    private final ConfigurationRepository configurationRepository;
    private final IssueServiceRegistry issueServiceRegistry;
    private final SecurityService securityService;

    @Autowired
    public CombinedIssueServiceConfigurationServiceImpl(ConfigurationRepository configurationRepository, IssueServiceRegistry issueServiceRegistry, SecurityService securityService) {
        this.configurationRepository = configurationRepository;
        this.issueServiceRegistry = issueServiceRegistry;
        this.securityService = securityService;
    }

    @Override
    public List<CombinedIssueServiceConfiguration> getConfigurationList() {
        return this.configurationRepository.list(CombinedIssueServiceConfiguration.class);
    }

    @Override
    public Optional<CombinedIssueServiceConfiguration> getConfigurationByName(String name) {
        return this.configurationRepository.find(CombinedIssueServiceConfiguration.class, name);
    }

    @Override
    public List<IssueServiceConfigurationRepresentation> getAvailableIssueServiceConfigurations() {
        return this.issueServiceRegistry.getAvailableIssueServiceConfigurations().stream().filter(issueServiceConfigurationRepresentation -> !StringUtils.equals((CharSequence)issueServiceConfigurationRepresentation.getServiceId(), (CharSequence)"combined")).collect(Collectors.toList());
    }

    @Override
    public CombinedIssueServiceConfiguration newConfiguration(CombinedIssueServiceConfiguration configuration) {
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        this.configurationRepository.save((Configuration)configuration);
        return configuration;
    }

    @Override
    public CombinedIssueServiceConfiguration getConfiguration(String name) {
        return this.getConfigurationByName(name).orElseThrow(() -> new ConfigurationNotFoundException(name));
    }

    @Override
    public void deleteConfiguration(String name) {
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        this.configurationRepository.delete(CombinedIssueServiceConfiguration.class, name);
    }

    @Override
    public void updateConfiguration(String name, CombinedIssueServiceConfiguration configuration) {
        this.securityService.checkGlobalFunction(GlobalSettings.class);
        Validate.isTrue((boolean)StringUtils.equals((CharSequence)name, (CharSequence)configuration.getName()), (String)"Configuration name must match", (Object[])new Object[0]);
        this.configurationRepository.save((Configuration)configuration);
    }
}

